/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.web3.impl;

import EDU.oswego.cs.dl.util.concurrent.Mutex;
import com.sap.mw.jco.JCO;
import java.util.Properties;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.web3.Web3Client;
import org.apache.cocoon.components.web3.Web3DataSource;
import org.apache.cocoon.components.web3.impl.Web3Properties;

public class Web3DataSourceImpl
extends AbstractLogEnabled
implements Web3DataSource,
ThreadSafe {
    protected Web3Properties properties = null;
    protected int poolsize = 0;
    protected int current_clients = 0;
    protected String mySID = null;
    protected boolean trace = false;
    protected int level = 0;
    private static Mutex lock = new Mutex();
    protected ServiceManager manager;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        if (null != configuration) {
            this.properties = new Web3Properties();
            Configuration child = configuration.getChild("pool");
            this.trace = child.getAttributeAsBoolean("trace", false);
            this.level = child.getAttributeAsInteger("level", 0);
            this.mySID = configuration.getAttribute("name");
            this.poolsize = child.getAttributeAsInteger("size");
            this.properties.put("jco.client.client", child.getChild("client").getValue());
            this.properties.put("jco.client.user", child.getChild("user").getValue());
            this.properties.put("jco.client.passwd", child.getChild("password").getValue());
            this.properties.put("jco.client.ashost", child.getChild("route").getValue());
            this.properties.put("jco.client.sysnr", child.getChild("system").getValue());
            this.properties.put("sap.gateway", child.getChild("gateway").getValue(""));
            this.properties.put("sap.programid", child.getChild("program-id").getValue(""));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Configure R3DataSource [mySID=" + this.mySID);
            }
        } else {
            this.getLogger().error("Couldn't configure Web3DataSource. No configuration provided!");
        }
    }

    public void initialize() throws Exception {
        try {
            try {
                lock.acquire();
                JCO.addClientPool((String)this.mySID, (int)this.poolsize, (Properties)this.properties);
                JCO.getClientPoolManager().getPool(this.mySID).setTrace(this.trace);
                JCO.setTraceLevel((int)this.level);
            }
            catch (Exception ex) {
                this.getLogger().error("Couldn't initialize Web3DataSource " + this.mySID, (Throwable)ex);
                throw new Exception(ex.getMessage() + this.mySID);
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            lock.release();
            throw throwable;
        }
        lock.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Web3Client getWeb3Client() throws Exception {
        Web3Client theClient = null;
        if (this.current_clients + 1 >= this.poolsize) return theClient;
        ++this.current_clients;
        try {
            block4: {
                try {
                    lock.acquire();
                    theClient = (Web3Client)this.manager.lookup("org.apache.cocoon.components.web3.Web3Client");
                    theClient.initClient(JCO.getClient((String)this.mySID));
                    if (!this.getLogger().isDebugEnabled()) break block4;
                    this.getLogger().debug("returning client " + theClient);
                }
                catch (Exception ex) {
                    this.getLogger().error(this.mySID, (Throwable)ex);
                    throw new Exception(ex.getMessage());
                }
            }
            Object var4_2 = null;
            lock.release();
            return theClient;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseWeb3Client(Web3Client client) {
        try {
            try {
                lock.acquire();
                client.releaseClient();
                --this.current_clients;
                this.manager.release((Object)client);
            }
            catch (Exception x) {
                this.getLogger().error(x.getMessage(), (Throwable)x);
                Object var4_3 = null;
                lock.release();
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.release();
            throw throwable;
        }
        lock.release();
    }

    public void dispose() {
        try {
            JCO.removeClientPool((String)this.mySID);
        }
        catch (Exception ex) {
            this.getLogger().error("Web3DataSource: couldn't return Web3DataSource", (Throwable)ex);
        }
        this.properties = null;
        this.mySID = null;
        this.getLogger().debug("Web3DataSource disposed.");
    }
}

