/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import org.tigris.subversion.svnant.SvnAntException;
import org.tigris.subversion.svnant.SvnAntValidationException;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Move
extends SvnCommand {
    private File srcPath = null;
    private File destPath = null;
    private SVNUrl srcUrl = null;
    private SVNUrl destUrl = null;
    private String message = null;
    private boolean force = false;

    public void execute() throws SvnAntException {
        if (this.srcPath != null) {
            try {
                this.svnClient.move(this.srcPath, this.destPath, this.force);
            }
            catch (SVNClientException sVNClientException) {
                throw new SvnAntException("Can't copy", sVNClientException);
            }
        }
        try {
            this.svnClient.move(this.srcUrl, this.destUrl, this.message, SVNRevision.HEAD);
        }
        catch (SVNClientException sVNClientException) {
            throw new SvnAntException("Can't copy", sVNClientException);
        }
    }

    protected void validateAttributes() throws SvnAntValidationException {
        if (this.srcPath == null && this.srcUrl == null || this.srcPath != null && this.srcUrl != null) {
            throw new SvnAntValidationException("Either srcPath attribute or srcUrl attribute must be set");
        }
        if (this.srcPath != null) {
            if (this.destPath == null) {
                throw new SvnAntValidationException("destPath attribute must be set when srcPath is set");
            }
            if (this.destUrl != null) {
                throw new SvnAntValidationException("destUrl attribute cannot be used when srcPath is set");
            }
        }
        if (this.srcUrl != null) {
            if (this.destUrl == null) {
                throw new SvnAntValidationException("destUrl attribute must be set when srcUrl is set");
            }
            if (this.destPath != null) {
                throw new SvnAntValidationException("destPath attribute cannot be used when srcUrl is set");
            }
            if (this.message == null) {
                throw new SvnAntValidationException("message attribute must be set when srcUrl is set");
            }
        }
    }

    public void setSrcPath(File file) {
        this.srcPath = file;
    }

    public void setDestPath(File file) {
        this.destPath = file;
    }

    public void setSrcUrl(SVNUrl sVNUrl) {
        this.srcUrl = sVNUrl;
    }

    public void setDestUrl(SVNUrl sVNUrl) {
        this.destUrl = sVNUrl;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }
}

