/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.UnparsedTextURIResolver;
import net.sf.saxon.trans.XPathException;

public class StandardUnparsedTextResolver
implements UnparsedTextURIResolver {
    private boolean debug = false;

    public void setDebugging(boolean bl) {
        this.debug = bl;
    }

    public Reader resolve(URI uRI, String string, Configuration configuration) throws XPathException {
        URL uRL;
        if (this.debug) {
            System.err.println("unparsed-text(): processing " + uRI);
            System.err.println("unparsed-text(): requested encoding = " + string);
        }
        try {
            uRL = uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            DynamicError dynamicError = new DynamicError("Cannot convert absolute URI to URL", malformedURLException);
            dynamicError.setErrorCode("XTDE1170");
            throw dynamicError;
        }
        try {
            Object object;
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            InputStream inputStream = uRLConnection.getInputStream();
            if (this.debug) {
                System.err.println("unparsed-text(): established connection");
            }
            try {
                if (!inputStream.markSupported()) {
                    inputStream = new BufferedInputStream(inputStream);
                }
                boolean bl = false;
                if (!"file".equals(uRLConnection.getURL().getProtocol())) {
                    object = uRLConnection.getContentType();
                    if (this.debug) {
                        System.err.println("unparsed-text(): content type = " + (String)object);
                    }
                    if (object != null) {
                        Object object2 = null;
                        int n = ((String)object).indexOf(59);
                        object2 = n >= 0 ? ((String)object).substring(0, n) : object;
                        object2 = ((String)object2).trim();
                        if (this.debug) {
                            System.err.println("unparsed-text(): media type = " + (String)object2);
                        }
                        bl = !(!((String)object2).startsWith("application/") && !((String)object2).startsWith("text/") || !((String)object2).endsWith("/xml") && !((String)object2).endsWith("+xml"));
                        String string2 = null;
                        n = ((String)object).toLowerCase().indexOf("charset");
                        if (n >= 0) {
                            if ((n = ((String)object).indexOf(61, n + 7)) >= 0) {
                                string2 = ((String)object).substring(n + 1);
                            }
                            if ((n = string2.indexOf(59)) > 0) {
                                string2 = string2.substring(0, n);
                            }
                            if ((n = string2.indexOf(40)) > 0) {
                                string2 = string2.substring(0, n);
                            }
                            if ((n = string2.indexOf(34)) > 0) {
                                string2 = string2.substring(n + 1, string2.indexOf(34, n + 2));
                            }
                            if (this.debug) {
                                System.err.println("unparsed-text(): charset = " + string2.trim());
                            }
                            string = string2.trim();
                        }
                    }
                }
                if (string == null || bl) {
                    inputStream.mark(100);
                    object = new byte[100];
                    int n = inputStream.read((byte[])object, 0, 100);
                    inputStream.reset();
                    string = this.inferEncoding((byte[])object, n);
                    if (this.debug) {
                        System.err.println("unparsed-text(): inferred encoding = " + string);
                    }
                }
            }
            catch (IOException iOException) {
                string = "UTF-8";
            }
            Charset charset = Charset.forName(string);
            object = charset.newDecoder();
            object = ((CharsetDecoder)object).onMalformedInput(CodingErrorAction.REPORT);
            object = ((CharsetDecoder)object).onUnmappableCharacter(CodingErrorAction.REPORT);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, (CharsetDecoder)object));
            return bufferedReader;
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
    }

    private String inferEncoding(byte[] byArray, int n) {
        if (n >= 2) {
            if (this.ch(byArray[0]) == 254 && this.ch(byArray[1]) == 255) {
                if (this.debug) {
                    System.err.println("unparsed-text(): found UTF-16 byte order mark");
                }
                return "UTF-16";
            }
            if (this.ch(byArray[0]) == 255 && this.ch(byArray[1]) == 254) {
                if (this.debug) {
                    System.err.println("unparsed-text(): found UTF-16LE byte order mark");
                }
                return "UTF-16LE";
            }
        }
        if (n >= 3 && this.ch(byArray[0]) == 239 && this.ch(byArray[1]) == 187 && this.ch(byArray[2]) == 191) {
            if (this.debug) {
                System.err.println("unparsed-text(): found UTF-8 byte order mark");
            }
            return "UTF-8";
        }
        if (n >= 4) {
            if (this.ch(byArray[0]) == 60 && this.ch(byArray[1]) == 63 && this.ch(byArray[2]) == 120 && this.ch(byArray[3]) == 109 && this.ch(byArray[4]) == 108) {
                if (this.debug) {
                    System.err.println("unparsed-text(): found XML declaration");
                }
                FastStringBuffer fastStringBuffer = new FastStringBuffer(n);
                for (int i = 0; i < n; ++i) {
                    fastStringBuffer.append((char)byArray[i]);
                }
                String string = fastStringBuffer.toString();
                int n2 = string.indexOf("encoding");
                if (n2 >= 0) {
                    n2 += 8;
                    while (n2 < string.length() && " \n\r\t=\"'".indexOf(string.charAt(n2)) >= 0) {
                        ++n2;
                    }
                    fastStringBuffer.setLength(0);
                    while (n2 < string.length() && string.charAt(n2) != '\"' && string.charAt(n2) != '\'') {
                        fastStringBuffer.append(string.charAt(n2++));
                    }
                    if (this.debug) {
                        System.err.println("unparsed-text(): encoding in XML declaration = " + fastStringBuffer.toString());
                    }
                    return fastStringBuffer.toString();
                }
                if (this.debug) {
                    System.err.println("unparsed-text(): no encoding found in XML declaration");
                }
            }
        } else {
            if (n > 0 && byArray[0] == 0 && byArray[2] == 0 && byArray[4] == 0 && byArray[6] == 0) {
                if (this.debug) {
                    System.err.println("unparsed-text(): even-numbered bytes are zero, inferring UTF-16");
                }
                return "UTF-16";
            }
            if (n > 1 && byArray[1] == 0 && byArray[3] == 0 && byArray[5] == 0 && byArray[7] == 0) {
                if (this.debug) {
                    System.err.println("unparsed-text(): odd-numbered bytes are zero, inferring UTF-16LE");
                }
                return "UTF-16LE";
            }
        }
        if (this.debug) {
            System.err.println("unparsed-text(): assuming fallback encoding (UTF-8)");
        }
        return "UTF-8";
    }

    private int ch(byte by) {
        return by & 0xFF;
    }
}

