/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.io.Serializable;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.TraceInstruction;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public final class XSLTemplate
extends StyleElement
implements StylesheetProcedure {
    private String matchAtt = null;
    private String modeAtt = null;
    private String nameAtt = null;
    private String priorityAtt = null;
    private String asAtt = null;
    private int[] modeNameCodes;
    private String diagnosticId;
    private Pattern match;
    private boolean prioritySpecified;
    private double priority;
    private SlotManager stackFrameMap;
    private Template compiledTemplate = new Template();
    private SequenceType requiredType = null;
    private boolean hasRequiredParams = false;

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    protected boolean isPermittedChild(StyleElement styleElement) {
        return styleElement instanceof XSLParam;
    }

    public int getTemplateFingerprint() {
        try {
            String string;
            if (this.getObjectFingerprint() == -1 && (string = this.getAttributeValue("name")) != null) {
                this.setObjectNameCode(this.makeNameCode(string.trim()));
            }
            return this.getObjectFingerprint();
        }
        catch (NamespaceException namespaceException) {
            return -1;
        }
        catch (XPathException xPathException) {
            return -1;
        }
    }

    protected ItemType getReturnedItemType() {
        if (this.requiredType == null) {
            return this.getCommonChildItemType();
        }
        return this.requiredType.getPrimaryType();
    }

    private int getMinImportPrecedence() {
        return this.getContainingStylesheet().getMinImportPrecedence();
    }

    public void prepareAttributes() throws XPathException {
        Object object;
        int n;
        int n2;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (n2 = 0; n2 < attributeCollection.getLength(); ++n2) {
            n = attributeCollection.getNameCode(n2);
            object = this.getNamePool().getClarkName(n);
            if (object == "mode") {
                this.modeAtt = attributeCollection.getValue(n2).trim();
                continue;
            }
            if (object == "name") {
                this.nameAtt = attributeCollection.getValue(n2).trim();
                continue;
            }
            if (object == "match") {
                this.matchAtt = attributeCollection.getValue(n2);
                continue;
            }
            if (object == "priority") {
                this.priorityAtt = attributeCollection.getValue(n2).trim();
                continue;
            }
            if (object == "as") {
                this.asAtt = attributeCollection.getValue(n2);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        try {
            if (this.modeAtt == null) {
                this.modeNameCodes = new int[1];
                this.modeNameCodes[0] = -1;
            } else {
                if (this.matchAtt == null) {
                    this.compileError("The mode attribute must be absent if the match attribute is absent", "XTSE0500");
                }
                n2 = 0;
                n = 0;
                object = new StringTokenizer(this.modeAtt);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    ((StringTokenizer)object).nextToken();
                    ++n2;
                }
                if (n2 == 0) {
                    this.compileError("The mode attribute must not be empty", "XTSE0550");
                }
                this.modeNameCodes = new int[n2];
                n2 = 0;
                object = new StringTokenizer(this.modeAtt);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    int n3;
                    String string = ((StringTokenizer)object).nextToken();
                    if ("#default".equals(string)) {
                        n3 = -1;
                    } else if ("#all".equals(string)) {
                        n = 1;
                        n3 = -2;
                    } else {
                        n3 = this.makeNameCode(string);
                    }
                    for (int i = 0; i < n2; ++i) {
                        if (this.modeNameCodes[i] != n3) continue;
                        this.compileError("In the list of modes, the value " + string + " is duplicated", "XTSE0550");
                    }
                    this.modeNameCodes[n2++] = n3;
                }
                if (n != 0 && n2 > 1) {
                    this.compileError("mode='#all' cannot be combined with other modes", "XTSE0550");
                }
            }
            if (this.nameAtt != null) {
                n2 = this.makeNameCode(this.nameAtt.trim());
                this.setObjectNameCode(n2);
                this.diagnosticId = this.nameAtt;
            }
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage(), "XTSE0280");
        }
        catch (XPathException xPathException) {
            if (xPathException.getErrorCodeLocalPart() == null) {
                xPathException.setErrorCode("XTSE0280");
            } else if (xPathException.getErrorCodeLocalPart().equals("XTSE0020")) {
                xPathException.setErrorCode("XTSE0550");
            }
            this.compileError(xPathException);
        }
        boolean bl = this.prioritySpecified = this.priorityAtt != null;
        if (this.prioritySpecified) {
            if (this.matchAtt == null) {
                this.compileError("The priority attribute must be absent if the match attribute is absent", "XTSE0500");
            }
            try {
                if (!DecimalValue.castableAsDecimal(this.priorityAtt)) {
                    this.compileError("Invalid numeric value for priority (" + this.priority + ')', "XTSE0530");
                }
                this.priority = Double.parseDouble(this.priorityAtt.trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.compileError("Invalid numeric value for priority (" + this.priority + ')', "XTSE0530");
            }
        }
        if (this.matchAtt != null) {
            this.match = this.makePattern(this.matchAtt);
            if (this.diagnosticId == null) {
                this.diagnosticId = "match=\"" + this.matchAtt + '\"';
                if (this.modeAtt != null) {
                    this.diagnosticId = this.diagnosticId + " mode=\"" + this.modeAtt + '\"';
                }
            }
        }
        if (this.match == null && this.nameAtt == null) {
            this.compileError("xsl:template must have a name or match attribute (or both)", "XTSE0500");
        }
        if (this.asAtt != null) {
            this.requiredType = this.makeSequenceType(this.asAtt);
        }
    }

    public void validate() throws XPathException {
        NodeInfo nodeInfo;
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        this.checkTopLevel(null);
        if (this.match != null) {
            this.typeCheck("match", this.match);
            if (this.match.getNodeTest() instanceof EmptySequenceTest) {
                try {
                    this.getConfiguration().getErrorListener().warning(new TransformerException("Match pattern cannot match any nodes", this));
                }
                catch (TransformerException transformerException) {
                    this.compileError(transformerException);
                }
            }
        }
        this.markTailCalls();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (!(nodeInfo instanceof XSLParam) || !((XSLParam)nodeInfo).isRequiredParam()) continue;
            this.hasRequiredParams = true;
            break;
        }
    }

    public void markTailCalls() {
        StyleElement styleElement;
        if (this.requiredType == null && (styleElement = this.getLastChildInstruction()) != null) {
            styleElement.markTailCalls();
        }
    }

    public Expression compile(Executable executable) throws XPathException {
        Serializable serializable;
        Serializable serializable2;
        Expression expression = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true);
        if (expression == null) {
            expression = Literal.makeLiteral(EmptySequence.getInstance());
        }
        this.compiledTemplate.setBody(expression);
        this.compiledTemplate.setStackFrameMap(this.stackFrameMap);
        this.compiledTemplate.setExecutable(this.getExecutable());
        this.compiledTemplate.setSystemId(this.getSystemId());
        this.compiledTemplate.setLineNumber(this.getLineNumber());
        this.compiledTemplate.setHasRequiredParams(this.hasRequiredParams);
        Serializable serializable3 = null;
        try {
            serializable3 = expression.simplify(this.getStaticContext());
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
        try {
            if (this.requiredType != null) {
                serializable2 = new RoleLocator(7, this.diagnosticId, 0, null);
                ((RoleLocator)serializable2).setSourceLocator(new ExpressionLocation(this));
                ((RoleLocator)serializable2).setErrorCode("XTTE0505");
                serializable3 = TypeChecker.staticTypeCheck((Expression)serializable3, this.requiredType, false, (RoleLocator)serializable2, this.getStaticContext());
            }
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
        this.compiledTemplate.setBody((Expression)serializable3);
        this.compiledTemplate.init(this.getObjectFingerprint(), this.getPrecedence(), this.getMinImportPrecedence());
        if (this.getConfiguration().isCompileWithTracing()) {
            serializable2 = new TraceInstruction((Expression)serializable3, this);
            ((Expression)serializable2).setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            ((Expression)serializable2).setParentExpression(this.compiledTemplate);
            serializable3 = serializable2;
            this.compiledTemplate.setBody((Expression)serializable3);
        }
        serializable2 = Type.ITEM_TYPE;
        if (this.getObjectFingerprint() == -1) {
            serializable2 = this.match.getNodeTest();
        }
        try {
            serializable = ((Expression)serializable3).typeCheck(this.staticContext, (ItemType)serializable2);
            serializable = ((Expression)serializable).optimize(this.getConfiguration().getOptimizer(), this.staticContext, (ItemType)serializable2);
            if (serializable3 != serializable) {
                this.compiledTemplate.setBody((Expression)serializable);
                serializable3 = serializable;
            }
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
        this.allocateSlots((Expression)serializable3);
        if (this.match != null) {
            serializable = this.getPrincipalStylesheet().getRuleManager();
            for (int i = 0; i < this.modeNameCodes.length; ++i) {
                int n = this.modeNameCodes[i];
                Mode mode = ((RuleManager)serializable).getMode(n, true);
                if (this.prioritySpecified) {
                    ((RuleManager)serializable).setHandler(this.match, this.compiledTemplate, mode, this.getPrecedence(), this.priority);
                    continue;
                }
                ((RuleManager)serializable).setHandler(this.match, this.compiledTemplate, mode, this.getPrecedence());
            }
            this.allocatePatternSlots(this.match, this.getSlotManager());
        }
        if (this.isExplaining()) {
            System.err.println("Optimized expression tree for template at line " + this.getLineNumber() + " in " + this.getSystemId() + ':');
            ((Expression)serializable3).display(10, System.err, this.getConfiguration());
        }
        return null;
    }

    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public Template getCompiledTemplate() {
        return this.compiledTemplate;
    }

    public int getConstructType() {
        return 181;
    }
}

