/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.repository.impl;

import java.io.IOException;
import java.util.List;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.repository.helpers.CredentialsToken;
import org.apache.cocoon.components.repository.helpers.RepositoryVersioningHelper;
import org.apache.cocoon.components.repository.impl.WebDAVRepository;
import org.apache.cocoon.components.webdav.WebDAVUtil;
import org.apache.commons.httpclient.HttpException;

public class WebDAVRepositoryVersioningHelper
extends AbstractLogEnabled
implements RepositoryVersioningHelper,
Serviceable,
Disposable,
Component {
    private ServiceManager manager;
    private WebDAVRepository repo;
    private CredentialsToken credentials;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void dispose() {
        this.manager = null;
    }

    public WebDAVRepositoryVersioningHelper(CredentialsToken credentials, WebDAVRepository repo) {
        this.credentials = credentials;
        this.repo = repo;
    }

    public boolean checkout(String uri) {
        try {
            WebDAVUtil.getWebdavResource(this.repo.getAbsoluteURI(uri)).checkoutMethod();
            return true;
        }
        catch (HttpException he) {
            this.getLogger().error("HTTP Error checking out " + uri, (Throwable)he);
        }
        catch (IOException ioe) {
            this.getLogger().error("IO Error checking out " + uri, (Throwable)ioe);
        }
        return false;
    }

    public boolean checkin(String uri) {
        try {
            WebDAVUtil.getWebdavResource(this.repo.getAbsoluteURI(uri)).checkinMethod();
            return true;
        }
        catch (HttpException he) {
            this.getLogger().error("HTTP Error checking in " + uri, (Throwable)he);
        }
        catch (IOException ioe) {
            this.getLogger().error("IO Error checking in " + uri, (Throwable)ioe);
        }
        return false;
    }

    public boolean uncheckout(String uri) {
        try {
            WebDAVUtil.getWebdavResource(this.repo.getAbsoluteURI(uri)).uncheckoutMethod();
            return true;
        }
        catch (HttpException he) {
            this.getLogger().error("HTTP Error while uncheckout " + uri, (Throwable)he);
        }
        catch (IOException ioe) {
            this.getLogger().error("IO Error while uncheckout " + uri, (Throwable)ioe);
        }
        return false;
    }

    public boolean isVersioned(String uri) {
        throw new UnsupportedOperationException();
    }

    public boolean setVersioned(String uri, boolean versioned) {
        try {
            if (!versioned) {
                return false;
            }
            return WebDAVUtil.getWebdavResource(this.repo.getAbsoluteURI(uri)).versionControlMethod(this.repo.getAbsoluteURI(uri));
        }
        catch (HttpException he) {
            this.getLogger().error("HTTP Error while versioncontrol " + uri, (Throwable)he);
        }
        catch (IOException ioe) {
            this.getLogger().error("IO Error while versioncontrol " + uri, (Throwable)ioe);
        }
        return false;
    }

    public List getVersions(String uri) {
        throw new UnsupportedOperationException();
    }
}

