/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral.javagroups;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.jcs.auxiliary.lateral.javagroups.JGConnectionHolder;
import org.apache.jcs.auxiliary.lateral.javagroups.LateralJGReceiverConnection;
import org.apache.jcs.auxiliary.lateral.javagroups.behavior.IJGConstants;
import org.apache.jcs.auxiliary.lateral.javagroups.behavior.ILateralCacheJGListener;
import org.jgroups.Channel;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Message;

public class LateralJGReceiver
implements IJGConstants,
Runnable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$lateral$javagroups$LateralJGReceiver == null ? (class$org$apache$jcs$auxiliary$lateral$javagroups$LateralJGReceiver = LateralJGReceiver.class$("org.apache.jcs.auxiliary.lateral.javagroups.LateralJGReceiver")) : class$org$apache$jcs$auxiliary$lateral$javagroups$LateralJGReceiver));
    private ILateralCacheJGListener ilcl;
    private ILateralCacheAttributes ilca;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$lateral$javagroups$LateralJGReceiver;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Listening");
            }
            JGConnectionHolder holder = JGConnectionHolder.getInstance(this.ilca);
            Channel javagroups = holder.getChannel();
            holder.getDispatcher();
            if (javagroups == null) {
                log.error((Object)"JavaGroups is null");
                throw new IOException("javagroups is null");
            }
            int conProbCnt = 0;
            while (true) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Wating for messages.");
                }
                Message mes = null;
                try {
                    Object obj = javagroups.receive(0L);
                    if (obj != null && obj instanceof Message) {
                        mes = (Message)obj;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Starting new socket node.");
                        }
                        new Thread(new LateralJGReceiverConnection(mes, this.ilcl)).start();
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug(obj);
                }
                catch (ChannelNotConnectedException cnce) {
                    if (conProbCnt % 5 == 0) {
                        log.warn((Object)cnce);
                    }
                    if (++conProbCnt >= 2000) {
                        log.error((Object)("Couldn't get connected to group after " + conProbCnt + " tries"));
                        return;
                    }
                    LateralJGReceiver lateralJGReceiver = this;
                    synchronized (lateralJGReceiver) {
                        this.wait(10L);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"problem receiving", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Major connection problem", (Throwable)e);
        }
    }

    public LateralJGReceiver(ILateralCacheAttributes ilca, ILateralCacheJGListener ilcl) {
        this.ilcl = ilcl;
        this.ilca = ilca;
        if (log.isDebugEnabled()) {
            log.debug((Object)("ilcl = " + ilcl));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

