/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.render.afp.modca.AbstractAFPObject;
import org.apache.fop.render.afp.modca.ImageSizeParameter;
import org.apache.fop.render.afp.tools.BinaryUtils;

public class ImageContent
extends AbstractAFPObject {
    private ImageSizeParameter _imageSizeParameter = null;
    private byte _encoding = (byte)3;
    private byte _size = 1;
    private byte _compression = (byte)-64;
    private byte _colorModel = 1;
    private byte[] _data = null;

    public void setImageSize(int hresol, int vresol, int hsize, int vsize) {
        this._imageSizeParameter = new ImageSizeParameter(hresol, vresol, hsize, vsize);
    }

    public void setImageEncoding(byte encoding) {
        this._encoding = encoding;
    }

    public void setImageCompression(byte compression) {
        this._compression = compression;
    }

    public void setImageIDESize(byte size) {
        this._size = size;
    }

    public void setImageIDEColorModel(byte colorModel) {
        this._colorModel = colorModel;
    }

    public void setImageData(byte[] data) {
        this._data = data;
    }

    public void writeDataStream(OutputStream os) throws IOException {
        this.writeStart(os);
        if (this._imageSizeParameter != null) {
            this._imageSizeParameter.writeDataStream(os);
        }
        os.write(this.getImageEncodingParameter());
        os.write(this.getImageIDESizeParameter());
        os.write(this.getIDEStructureParameter());
        os.write(this.getExternalAlgorithmParameter());
        if (this._data != null) {
            int len;
            for (int off = 0; off < this._data.length; off += len) {
                len = Math.min(30000, this._data.length - off);
                os.write(this.getImageDataStart(len));
                os.write(this._data, off, len);
            }
        }
        this.writeEnd(os);
    }

    private void writeStart(OutputStream os) throws IOException {
        byte[] data = new byte[]{-111, 1, -1};
        os.write(data);
    }

    private void writeEnd(OutputStream os) throws IOException {
        byte[] data = new byte[]{-109, 0};
        os.write(data);
    }

    private byte[] getImageDataStart(int len) {
        byte[] data = new byte[]{-2, -110, 0, 0};
        byte[] l = BinaryUtils.convert(len, 2);
        data[2] = l[0];
        data[3] = l[1];
        return data;
    }

    private byte[] getImageEncodingParameter() {
        byte[] data = new byte[]{-107, 2, this._encoding, 1};
        return data;
    }

    private byte[] getExternalAlgorithmParameter() {
        if (this._encoding == -125 && this._compression != 0) {
            byte[] data = new byte[]{-107, 0, 16, 0, -125, 0, 0, 0, this._compression, 0, 0, 0};
            data[1] = (byte)(data.length - 2);
            return data;
        }
        return new byte[0];
    }

    private byte[] getImageIDESizeParameter() {
        byte[] data = new byte[]{-106, 1, this._size};
        return data;
    }

    private byte[] getIDEStructureParameter() {
        if (this._colorModel != 0 && this._size == 24) {
            byte bits = (byte)(this._size / 3);
            byte[] data = new byte[]{-101, 0, 0, 0, this._colorModel, 0, 0, 0, bits, bits, bits};
            data[1] = (byte)(data.length - 2);
            return data;
        }
        return new byte[0];
    }
}

