/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.lucene;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.lucene.LuceneData;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import fr.gouv.culture.sdx.utils.save.Saveable;
import fr.gouv.culture.sdx.utils.zip.ZipWrapper;
import java.io.File;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public abstract class LuceneDataStore
extends AbstractSdxObject
implements Saveable {
    protected boolean useCompoundFiles = true;
    public static final String ID_FIELD = "sdxdocid";
    public static final String ALL_FIELD = "sdxall";
    public static final String ALL_VALUE = "1";
    public static final String XML_LANG_FIELD = "xmllang";
    protected File fsdFile = null;
    protected FSDirectory fsd = null;
    protected Searcher searcher = null;
    protected Analyzer analyzer = new StandardAnalyzer();

    public LuceneDataStore() {
    }

    protected LuceneDataStore(File dir) {
        this.fsdFile = dir;
    }

    public String getIndexPath() {
        if (this.fsdFile == null) {
            return null;
        }
        return this.fsdFile.getAbsolutePath();
    }

    public boolean isUsingCompoundFiles() {
        return this.useCompoundFiles;
    }

    protected void init(boolean create) throws SDXException {
        this.getFSDirectory(create);
        this.verifyIndex();
        this.recycleSearcher();
    }

    protected void getFSDirectory(boolean create) throws SDXException {
        if (this.fsdFile != null && this.fsd == null) {
            this.fsd = this.getFSDirectory(this.fsdFile, create);
        }
    }

    protected FSDirectory getFSDirectory(File dir, boolean create) throws SDXException {
        FSDirectory l_fsDir = null;
        try {
            l_fsDir = FSDirectory.getDirectory((File)dir, (boolean)create);
            return l_fsDir;
        }
        catch (IOException e) {
            String[] args = new String[]{this.getIndexPath(), e.getMessage()};
            throw new SDXException(super.getLog(), 206, args, e);
        }
    }

    public void verifyIndex() throws SDXException {
        try {
            if (!IndexReader.indexExists((Directory)this.fsd)) {
                IndexWriter w = new IndexWriter((Directory)this.fsd, this.analyzer, true);
                w.close();
            }
        }
        catch (IOException e) {
            String[] args = new String[]{this.getIndexPath(), e.getMessage()};
            throw new SDXException(super.getLog(), 204, args, e);
        }
    }

    public synchronized void recycleSearcher() throws SDXException {
        try {
            if (this.searcher != null) {
                this.searcher.close();
                this.searcher = null;
            }
            this.searcher = new IndexSearcher((Directory)this.fsd);
        }
        catch (IOException e) {
            String[] args = new String[]{this.getIndexPath()};
            throw new SDXException(super.getLog(), 203, args, e);
        }
    }

    protected IndexWriter getWriter() throws IOException {
        return this.getWriter(false);
    }

    protected IndexWriter getWriter(boolean create) throws IOException {
        return this.getWriter((Directory)this.fsd, create);
    }

    protected synchronized IndexWriter getWriter(Directory directory) throws IOException {
        return this.getWriter(directory, false);
    }

    protected synchronized IndexWriter getWriter(Directory directory, boolean create) throws IOException {
        IndexWriter w = new IndexWriter(directory, this.analyzer, create);
        w.setUseCompoundFile(this.useCompoundFiles);
        return w;
    }

    protected IndexReader getReader() throws SDXException {
        try {
            return IndexReader.open((Directory)this.fsd);
        }
        catch (IOException e) {
            String[] args = new String[]{this.getIndexPath(), e.getMessage()};
            throw new SDXException(super.getLog(), 200, args, e);
        }
    }

    protected Searchable getSearcher() {
        return this.searcher;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void optimize() throws SDXException {
        block9: {
            IndexWriter w = null;
            try {
                try {
                    w = this.getWriter();
                    w.optimize();
                }
                catch (IOException e) {
                    String[] args = new String[]{this.getIndexPath()};
                    throw new SDXException(super.getLog(), 223, args, e);
                }
                Object var5_2 = null;
                if (w == null) break block9;
            }
            catch (Throwable throwable) {
                Object var5_3 = null;
                if (w != null) {
                    try {
                        w.close();
                    }
                    catch (IOException e) {
                        String[] args = new String[]{this.getIndexPath()};
                        throw new SDXException(super.getLog(), 223, args, e);
                    }
                }
                this.recycleSearcher();
                throw throwable;
            }
            try {}
            catch (IOException e) {
                String[] args = new String[]{this.getIndexPath()};
                throw new SDXException(super.getLog(), 223, args, e);
            }
            w.close();
        }
        this.recycleSearcher();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void write(Document lDoc) throws SDXException {
        if (lDoc == null) return;
        IndexWriter w = null;
        try {
            try {
                w = this.getWriter();
                w.addDocument(lDoc);
            }
            catch (IOException e) {
                String[] args = new String[]{this.getIndexPath(), e.getMessage()};
                throw new SDXException(super.getLog(), 204, args, e);
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            try {
                if (w == null) throw throwable;
                w.close();
                throw throwable;
            }
            catch (IOException e) {
                String[] args = new String[]{this.getIndexPath(), e.getMessage()};
                throw new SDXException(super.getLog(), 204, args, e);
            }
        }
        try {}
        catch (IOException e) {
            String[] args = new String[]{this.getIndexPath(), e.getMessage()};
            throw new SDXException(super.getLog(), 204, args, e);
        }
        if (w == null) return;
        w.close();
    }

    protected synchronized void writeLuceneData(LuceneData ld) throws SDXException {
        Document lDoc;
        if (ld != null && (lDoc = ld.getLuceneDocument()) != null) {
            this.write(lDoc);
        }
    }

    protected synchronized void delete(String docId) throws SDXException {
        if (Utilities.checkString(docId)) {
            String[] docIds = new String[]{docId};
            this.delete(docIds);
        }
    }

    protected synchronized void delete(String[] docIds) throws SDXException {
        if (docIds != null) {
            Term[] terms = new Term[docIds.length];
            for (int i = 0; i < docIds.length; ++i) {
                Term term;
                String docId = docIds[i];
                if (!Utilities.checkString(docId)) continue;
                terms[i] = term = new Term(ID_FIELD, docId);
            }
            this.delete(terms);
        }
    }

    public void delete(Term term) throws SDXException {
        Term[] terms = new Term[]{term};
        this.delete(terms);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void delete(Term[] terms) throws SDXException {
        if (terms == null) return;
        IndexReader r = null;
        try {
            try {
                for (int i = 0; i < terms.length; ++i) {
                    Term term = terms[i];
                    if (term == null) continue;
                    if (r == null) {
                        r = this.getReader();
                    }
                    r.deleteDocuments(term);
                }
                Object var6_7 = null;
            }
            catch (IOException e) {
                String[] args = new String[]{this.getIndexPath(), e.getMessage()};
                throw new SDXException(super.getLog(), 205, args, e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (r == null) throw throwable;
                r.close();
                throw throwable;
            }
            catch (IOException e) {
                String[] args = new String[]{this.getIndexPath(), e.getMessage(), "Unable to close IndexReader."};
                throw new SDXException(super.getLog(), 205, args, e);
            }
        }
        try {}
        catch (IOException e) {
            String[] args = new String[]{this.getIndexPath(), e.getMessage(), "Unable to close IndexReader."};
            throw new SDXException(super.getLog(), 205, args, e);
        }
        if (r == null) return;
        r.close();
    }

    protected void freeResources() throws IOException {
        if (this.searcher != null) {
            this.searcher.close();
            this.searcher = null;
        }
        if (this.fsd != null) {
            this.fsd.close();
            this.fsd = null;
        }
    }

    protected void finalize() throws Throwable {
        this.freeResources();
        super.finalize();
    }

    public synchronized Hits search(Query q) throws SDXException {
        return this.search(q, null);
    }

    public synchronized Hits search(Query q, Filter f) throws SDXException {
        try {
            if (q == null) {
                throw new SDXException(null, 218, null, null);
            }
            if (this.searcher == null) {
                this.recycleSearcher();
                if (this.searcher == null) {
                    String[] args = new String[2];
                    args[0] = this.getIndexPath();
                    throw new SDXException(super.getLog(), 203, args, null);
                }
            }
            if (f != null) {
                return this.searcher.search(q, f);
            }
            return this.searcher.search(q);
        }
        catch (IOException e) {
            String[] args = new String[]{this.getIndexPath(), e.getMessage()};
            throw new SDXException(super.getLog(), 202, args, e);
        }
    }

    public long size() {
        Hits h = null;
        try {
            h = this.search((Query)new TermQuery(new Term(ALL_FIELD, ALL_VALUE)));
            if (h != null) {
                return h.length();
            }
            return 0L;
        }
        catch (SDXException e) {
            return 0L;
        }
    }

    protected boolean initToSax() {
        return true;
    }

    protected void initVolatileObjectsToSax() {
    }

    public void backup(SaveParameters save_config) throws SDXException {
        if (save_config != null && save_config.getAttributeAsBoolean("all", false)) {
            save_config.setAttribute("type", "LUCENE");
            save_config.savePathInConfig(null);
            String id = this.getId();
            if (!id.equals("")) {
                save_config.setAttribute("id", this.getId());
            } else {
                id = "database";
            }
            String savedir = save_config.getStoreBasePath() + save_config.getAttribute("path", "");
            ZipWrapper zw = new ZipWrapper();
            if (this.fsd != null && this.fsd.getFile() != null) {
                zw.zipDirectory(savedir + File.separator + id + ".zip", this.fsd.getFile().getAbsolutePath());
            }
        }
    }

    public void restore(SaveParameters save_config) throws SDXException {
    }
}

