/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.user;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.user.AnonymousUserInformation;
import fr.gouv.culture.sdx.user.Group;
import fr.gouv.culture.sdx.user.Identity;
import fr.gouv.culture.sdx.user.User;
import fr.gouv.culture.sdx.user.UserInformation;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.database.Database;
import fr.gouv.culture.sdx.utils.database.DatabaseBacked;
import fr.gouv.culture.sdx.utils.database.DatabaseConnection;
import fr.gouv.culture.sdx.utils.database.DatabaseEntity;
import fr.gouv.culture.sdx.utils.database.Property;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.avalon.framework.parameters.Parameters;

public class UserDatabase
extends DatabaseBacked
implements Database {
    private static final String MEMBER_PROPERTY = "member";
    public static final String FIELD_PASSWORD = "password";
    public static final String FIELD_FIRSTNAME = "firstname";
    public static final String FIELD_LASTNAME = "lastname";
    public static final String FIELD_EMAIL = "email";
    public static final String FIELD_LOCALE = "locale";

    public UserDatabase(String id) throws SDXException {
        super.setId(id);
    }

    public void addMember(Group group, String id) throws SDXException {
        if (group == null || group.getId() == null || id == null || "".equals(id)) {
            return;
        }
        DatabaseEntity de = this._database.getEntity(id);
        if (de == null) {
            String[] args = new String[]{id};
            throw new SDXException(super.getLog(), 6000, args, null);
        }
        de.addProperty(MEMBER_PROPERTY, group.getId());
        this._database.update(de);
    }

    public void deleteMembers(Group group) throws SDXException {
        if (group == null) {
            return;
        }
        String groupName = group.getId();
        if (groupName == null) {
            return;
        }
        Parameters params = new Parameters();
        params.setParameter(MEMBER_PROPERTY, groupName);
        String[] users = this._database.search(params);
        if (users == null) {
            return;
        }
        DatabaseEntity[] updatedUsers = new DatabaseEntity[users.length];
        for (int i = 0; i < users.length; ++i) {
            DatabaseEntity updatedUser = new DatabaseEntity(users[i]);
            DatabaseEntity oldUser = this.getEntity(users[i]);
            Property[] oldProps = oldUser.getProperties();
            for (int j = 0; j < oldProps.length; ++j) {
                if (oldProps[j].getName().equals(MEMBER_PROPERTY)) {
                    String oldValue = oldProps[j].getValue();
                    if (oldValue == null || oldValue.equals(groupName)) continue;
                    updatedUser.addProperty(MEMBER_PROPERTY, oldValue);
                    continue;
                }
                updatedUser.addProperties(oldProps[j].getName(), oldProps[j].getValues());
            }
            updatedUsers[i] = updatedUser;
        }
        for (int j = 0; j < updatedUsers.length; ++j) {
            this._database.update(updatedUsers[j]);
        }
    }

    public void delete(Identity identity) throws SDXException {
        if (identity != null && identity.getId() != null) {
            this._database.delete(new DatabaseEntity(this.getId(identity)));
            if (identity.getDocType() == "group") {
                this.deleteMembers((Group)identity);
            }
        }
    }

    public void add(Identity identity, String password) throws SDXException {
        if (identity == null && identity.getId() == null) {
            return;
        }
        DatabaseEntity de = this._database.getEntity(this.getId(identity));
        if (de == null) {
            de = new DatabaseEntity(this.getId(identity));
        }
        if (identity instanceof User) {
            Locale locale;
            de.deleteProperty(FIELD_PASSWORD);
            if (password != null) {
                de.addProperty(FIELD_PASSWORD, password);
            }
            if ((locale = ((User)identity).getPreferredLocale()) != null) {
                de.deleteProperty(FIELD_LOCALE);
                de.addProperty(FIELD_LOCALE, locale.toString());
            }
            de.deleteProperty(FIELD_FIRSTNAME);
            de.addProperty(FIELD_FIRSTNAME, ((User)identity).getFirstname());
            de.deleteProperty(FIELD_LASTNAME);
            de.addProperty(FIELD_LASTNAME, ((User)identity).getLastname());
            de.deleteProperty(FIELD_EMAIL);
            de.addProperty(FIELD_EMAIL, ((User)identity).getEmail());
        }
        this._database.update(de);
    }

    public String[] getMembers(String groupName) throws SDXException {
        if (!Utilities.checkString(groupName)) {
            return null;
        }
        Parameters params = new Parameters();
        params.setParameter(MEMBER_PROPERTY, groupName);
        String[] users = this._database.search(params);
        if (users == null) {
            return null;
        }
        return users;
    }

    public Hashtable getParents(String id) throws SDXException {
        Hashtable table = new Hashtable();
        this.getParents(id, table);
        return table;
    }

    private void getParents(String id, Hashtable table) throws SDXException {
        DatabaseEntity de = this._database.getEntity(id);
        if (de == null) {
            return;
        }
        String[] groups = de.getPropertyValues(MEMBER_PROPERTY);
        if (groups == null) {
            return;
        }
        for (int i = 0; i < groups.length; ++i) {
            if (table.containsKey(groups[i])) continue;
            table.put(groups[i], new Group(groups[i]));
            this.getParents(groups[i], table);
        }
    }

    public boolean isMember(Identity identity, String groupName) throws SDXException {
        if (identity == null || identity.getId() == null || groupName == null) {
            return false;
        }
        DatabaseEntity de = new DatabaseEntity(identity.getId());
        String[] groups = de.getPropertyValues(MEMBER_PROPERTY);
        if (groups != null) {
            for (int j = 0; j < groups.length; ++j) {
                if (!groups[j].equals(groupName)) continue;
                return true;
            }
        }
        return false;
    }

    private String getId(Identity identity) {
        if (identity != null) {
            return identity.getId();
        }
        return null;
    }

    public boolean checkPassword(String id, String password) throws SDXException {
        if (id == null) {
            return false;
        }
        DatabaseEntity de = this._database.getEntity(id);
        if (de == null) {
            return false;
        }
        String pwd = de.getProperty(FIELD_PASSWORD);
        if (pwd == null) {
            return password == null;
        }
        if (password == null) {
            return false;
        }
        return password.equals(pwd);
    }

    public boolean changePassword(String id, String oldPass, String newPass) throws SDXException {
        if (!this.checkPassword(id, oldPass)) {
            return false;
        }
        if (Utilities.checkString(newPass)) {
            DatabaseEntity de = this._database.getEntity(id);
            if (de == null) {
                return false;
            }
            de.deleteProperty(FIELD_PASSWORD);
            de.addProperty(FIELD_PASSWORD, newPass);
            this._database.update(de);
            return true;
        }
        return false;
    }

    public UserInformation getUserInformation(String application, String username, Locale locale, String adminGroup) throws SDXException {
        if (username == null || username.equals("sdxAnonymous")) {
            AnonymousUserInformation aui = new AnonymousUserInformation(locale);
            aui.enableLogging(super.getLog());
            return aui;
        }
        DatabaseEntity de = this._database.getEntity(username);
        if (de == null) {
            return null;
        }
        Locale preferredLocale = locale;
        String sLocale = de.getProperty(FIELD_LOCALE);
        if (sLocale != null) {
            preferredLocale = this.parseLocaleString(sLocale);
        }
        User usr = new User(username);
        usr.enableLogging(super.getLog());
        UserInformation ui = new UserInformation();
        ui.enableLogging(super.getLog());
        ui.setUp(application, username, this.getParents(username), preferredLocale, de.getProperty(FIELD_FIRSTNAME), de.getProperty(FIELD_LASTNAME), de.getProperty(FIELD_EMAIL), adminGroup);
        return ui;
    }

    public boolean exists(String id) throws SDXException {
        DatabaseEntity de = this._database.getEntity(id);
        return de != null;
    }

    private Locale parseLocaleString(String locale) {
        if (!Utilities.checkString(locale)) {
            return null;
        }
        String lang = "";
        String country = "";
        String variant = "";
        if (locale.substring(0, 1).equals("_")) {
            country = locale.substring(1, 2);
            if (country.length() > 4) {
                variant = locale.substring(4);
            }
        } else {
            lang = locale.substring(0, 2);
            if (locale.length() > 4) {
                if (locale.substring(3, 4).equals("_")) {
                    if (locale.length() > 4) {
                        variant = locale.substring(4);
                    }
                } else {
                    country = locale.substring(3, 5);
                    if (locale.length() > 6) {
                        variant = locale.substring(6);
                    }
                }
            }
        }
        if (lang.equals("") && country.equals("")) {
            return null;
        }
        return new Locale(lang, country, variant);
    }

    public DatabaseEntity getEntity(String id) throws SDXException {
        return this._database.getEntity(id);
    }

    public DatabaseEntity[] getEntities() throws SDXException {
        return this._database.getEntities();
    }

    public String getPropertyValue(String entityId, String name) throws SDXException {
        return this._database.getPropertyValue(entityId, name);
    }

    public String[] getPropertyValues(String entityId, String propertyName) throws SDXException {
        return this._database.getPropertyValues(entityId, propertyName);
    }

    public Property[] getProperties(String entityId) throws SDXException {
        return this._database.getProperties(entityId);
    }

    public void save(DatabaseEntity ent) throws SDXException {
        this._database.save(ent);
    }

    public void delete(DatabaseEntity ent) throws SDXException {
        this._database.delete(ent);
    }

    public void update(DatabaseEntity ent) throws SDXException {
        this._database.update(ent);
    }

    public long size() {
        return this._database.size();
    }

    public void empty() throws SDXException {
        this._database.empty();
    }

    public boolean entityExists(String id) {
        return this._database.entityExists(id);
    }

    public String[] search(Parameters params) throws SDXException {
        return this._database.search(params);
    }

    public String[] search(Parameters params, int mode) throws SDXException {
        return this._database.search(params, mode);
    }

    public void optimize() throws SDXException {
        this._database.optimize();
    }

    public String getDatabaseDirectoryName() {
        return this._database.getDatabaseDirectoryName();
    }

    public DatabaseConnection getConnection() throws SDXException {
        return this._database.getConnection();
    }

    public void releaseConnection(DatabaseConnection conn) throws SDXException {
        this._database.releaseConnection(conn);
    }

    public void addProperty(String entityId, String propertyName, String propertyValue) throws SDXException {
        this._database.addProperty(entityId, propertyName, propertyValue);
    }

    public void removeProperty(String entityId, String propertyName, String propertyValue) throws SDXException {
        this._database.removeProperty(entityId, propertyName, propertyValue);
    }

    public void removeProperty(String propertyName, String propertyValue) throws SDXException {
        this._database.removeProperty(propertyName, propertyValue);
    }

    protected String getClassNameSuffix() {
        return "Database";
    }

    public String getWildcardSearchToken() {
        return this._database.getWildcardSearchToken();
    }

    protected boolean initToSax() {
        if (!super.initToSax()) {
            return false;
        }
        try {
            this._xmlizable_objects.put(MEMBER_PROPERTY, this.getEntities()[0].getProperty(MEMBER_PROPERTY));
        }
        catch (SDXException sDXException) {
            // empty catch block
        }
        return true;
    }

    protected void initVolatileObjectsToSax() {
        super.initVolatileObjectsToSax();
        try {
            this._xmlizable_objects.put(MEMBER_PROPERTY, this.getEntities()[0].getProperty(MEMBER_PROPERTY));
        }
        catch (SDXException sDXException) {
            // empty catch block
        }
    }

    public void backup(SaveParameters save_config) throws SDXException {
        if (save_config != null && save_config.isAllElementSelected()) {
            save_config.setAttribute("id", this.getId());
            save_config.setAttribute("type", "user");
            this._database.backup(save_config);
        }
    }

    public void restore(SaveParameters save_config) throws SDXException {
    }
}

