/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.analysis.filter;

import java.io.IOException;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class ISOLatin1AccentFilter
extends TokenFilter
implements LogEnabled {
    private Logger logger;

    public ISOLatin1AccentFilter(TokenStream input) {
        super(input);
    }

    public void setUp(TokenStream in) {
        this.input = in;
    }

    public final Token next() throws IOException {
        Token t = this.input.next();
        if (t == null) {
            return null;
        }
        String tokenText = t.termText();
        tokenText = ISOLatin1AccentFilter.removeAccents(tokenText);
        return new Token(tokenText, t.startOffset(), t.endOffset(), t.type());
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public static String removeAccents(String s) {
        if (s == null) {
            return s;
        }
        StringBuffer chars = new StringBuffer();
        block27: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '\u00c0': 
                case '\u00c1': 
                case '\u00c2': 
                case '\u00c3': 
                case '\u00c4': 
                case '\u00c5': {
                    chars.append("A");
                    continue block27;
                }
                case '\u00c6': {
                    chars.append("AE");
                    continue block27;
                }
                case '\u00c7': {
                    chars.append("C");
                    continue block27;
                }
                case '\u00c8': 
                case '\u00c9': 
                case '\u00ca': 
                case '\u00cb': {
                    chars.append("E");
                    continue block27;
                }
                case '\u00cc': 
                case '\u00cd': 
                case '\u00ce': 
                case '\u00cf': {
                    chars.append("I");
                    continue block27;
                }
                case '\u00d0': {
                    chars.append("D");
                    continue block27;
                }
                case '\u00d1': {
                    chars.append("N");
                    continue block27;
                }
                case '\u00d2': 
                case '\u00d3': 
                case '\u00d4': 
                case '\u00d5': 
                case '\u00d6': 
                case '\u00d8': {
                    chars.append("O");
                    continue block27;
                }
                case '\u0152': {
                    chars.append("OE");
                    continue block27;
                }
                case '\u00de': {
                    chars.append("TH");
                    continue block27;
                }
                case '\u00d9': 
                case '\u00da': 
                case '\u00db': 
                case '\u00dc': {
                    chars.append("U");
                    continue block27;
                }
                case '\u00dd': 
                case '\u0178': {
                    chars.append("Y");
                    continue block27;
                }
                case '\u00e0': 
                case '\u00e1': 
                case '\u00e2': 
                case '\u00e3': 
                case '\u00e4': 
                case '\u00e5': {
                    chars.append("a");
                    continue block27;
                }
                case '\u00e6': {
                    chars.append("ae");
                    continue block27;
                }
                case '\u00e7': {
                    chars.append("c");
                    continue block27;
                }
                case '\u00e8': 
                case '\u00e9': 
                case '\u00ea': 
                case '\u00eb': {
                    chars.append("e");
                    continue block27;
                }
                case '\u00ec': 
                case '\u00ed': 
                case '\u00ee': 
                case '\u00ef': {
                    chars.append("i");
                    continue block27;
                }
                case '\u00f0': {
                    chars.append("d");
                    continue block27;
                }
                case '\u00f1': {
                    chars.append("n");
                    continue block27;
                }
                case '\u00f2': 
                case '\u00f3': 
                case '\u00f4': 
                case '\u00f5': 
                case '\u00f6': 
                case '\u00f8': {
                    chars.append("o");
                    continue block27;
                }
                case '\u0153': {
                    chars.append("oe");
                    continue block27;
                }
                case '\u00df': {
                    chars.append("ss");
                    continue block27;
                }
                case '\u00fe': {
                    chars.append("th");
                    continue block27;
                }
                case '\u00f9': 
                case '\u00fa': 
                case '\u00fb': 
                case '\u00fc': {
                    chars.append("u");
                    continue block27;
                }
                case '\u00fd': 
                case '\u00ff': {
                    chars.append("y");
                    continue block27;
                }
                default: {
                    chars.append(s.charAt(i));
                }
            }
        }
        return chars.toString();
    }
}

