/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.JDBCRepository;
import fr.gouv.culture.sdx.utils.configuration.ConfigurationUtils;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class POSTGRESQLRepository
extends JDBCRepository {
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        ConfigurationUtils.checkConfAttributeValue("dsi", this.dsi, configuration.getLocation());
    }

    protected String getTableCreationQuery() {
        return "CREATE TABLE " + this.getTableName() + " ( " + "id" + " VARCHAR(255) NOT NULL, " + "data" + " bytea, PRIMARY KEY (" + "id" + "))";
    }

    protected String getEntriesWithLimitQuery(long offset, long number) {
        String query = "SELECT * FROM " + this.getTableName();
        query = query + " LIMIT " + String.valueOf(offset) + "," + String.valueOf(number) + ";";
        return query;
    }

    public void backup(SaveParameters save_config) throws SDXException {
        super.backup(save_config);
        if (save_config != null && save_config.getAttributeAsBoolean("all", false)) {
            save_config.setAttribute("type", "POSGRESQL");
        }
    }

    public void restore(SaveParameters save_config) throws SDXException {
        super.restore(save_config);
    }
}

