/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.thesaurus;

import org.apache.cocoon.xml.AbstractXMLPipe;

import java.util.ArrayList;

public abstract class AbstractThesaurusBuilder extends AbstractXMLPipe implements ThesaurusBuilder {

    /** Avalon super.getLog() to write information. */
    protected org.apache.avalon.framework.logger.Logger logger;

    /**
     * Sets the super.getLog() for this object.
     *
     * <p>
     * Setting the super.getLog() ensures proper logging of potential
     * errors. If not set, this class won't be able to log any
     * information. But it will still work.
     */
    public void enableLogging(org.apache.avalon.framework.logger.Logger logger) {
        this.logger = logger;
    }

    protected ArrayList concepts = new ArrayList();


    public Concept[] getConcepts() {
        if (concepts == null || concepts.size() == 0)
            return null;
        else
            return (Concept[]) concepts.toArray(new Concept[0]);
    }

}
