/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.oai;

import fr.gouv.culture.oai.OAIHarvester;
import fr.gouv.culture.oai.OAIObject;
import fr.gouv.culture.sdx.utils.save.Saveable;
import fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler.Target;

public interface DocumentBaseOAIHarvester extends OAIHarvester, Target, Saveable {

	interface ConfigurationNode {

		/**Configuration node name*/
		String OAI_DATA_PROVIDERS = "oai-data-providers";
		/**Configuration node name*/
		String OAI_VERB = "oai-verb";
		/**Configuration node name*/
		String OAI_IDENTIFIER = "oai-identifier";
		/**Configuration node name*/
		String NAME = "name";
		/**Configuration node name*/
		String ADMIN_EMAIL = OAIObject.Node.Name.ADMIN_EMAIL;
		/**Configuration node name*/
		String USER_AGENT = "userAgent";
		/**Configuration node name*/
		String URL = "url";
		/**Configuration node name*/
		String GRANULARITY = "granularity";
		/**Configuration node name*/
		String UPDATE = "update";
		/**Configuration node name*/
	    String ATTRIBUTE_USE_LAST_HARVEST_DATE = "useLastHarvestDate";
		/**Configuration node name*/
		String METADATA_PREFIX = OAIObject.Node.Name.METADATA_PREFIX;
		/**Configuration node name*/
		String SDX_REPOSITORY = "sdxRepository";
		/**Configuration node name*/
		String FROM = "from";
		/**Configuration node name*/
		String UNTIL = "until";
		/**Configuration node name*/
		String SET = "set";
		String KEEP_DELETED_RECORDS = "keepDeletedRecords";
		/**Configuration node name*/
		String NO_RECORDS_PER_BATCH = "noRecordsPerBatch";
	}
}
