/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.logkit;

import org.apache.avalon.framework.logger.Logger;
import org.apache.log.ErrorHandler;
import org.apache.log.LogEvent;
import org.apache.log.Priority;

public class ErrorHandlerAdapter
implements ErrorHandler {
    private final Logger m_reliableLogger;

    public ErrorHandlerAdapter(Logger reliableLogger) {
        if (reliableLogger == null) {
            throw new NullPointerException("reliableLogger");
        }
        this.m_reliableLogger = reliableLogger;
    }

    public void error(String message, Throwable throwable, LogEvent event) {
        this.m_reliableLogger.fatalError(message, throwable);
        Priority p = event.getPriority();
        String nestedMessage = "nested log event: " + event.getMessage();
        if (p == Priority.DEBUG) {
            this.m_reliableLogger.debug(nestedMessage, event.getThrowable());
        } else if (p == Priority.INFO) {
            this.m_reliableLogger.info(nestedMessage, event.getThrowable());
        } else if (p == Priority.WARN) {
            this.m_reliableLogger.warn(nestedMessage, event.getThrowable());
        } else if (p == Priority.ERROR) {
            this.m_reliableLogger.error(nestedMessage, event.getThrowable());
        } else if (p == Priority.FATAL_ERROR) {
            this.m_reliableLogger.fatalError(nestedMessage, event.getThrowable());
        } else {
            this.m_reliableLogger.error("unrecognized priority " + nestedMessage, event.getThrowable());
        }
    }
}

