/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceValidity;

public class PartSource
implements Source {
    private String protocol;
    private String uri;
    private Part part;

    public PartSource(String uri, Map objectModel) throws MalformedURLException, SourceException {
        this.uri = uri;
        int position = uri.indexOf(58) + 1;
        if (position == 0) {
            throw new MalformedURLException("No protocol found for part source in " + uri);
        }
        this.protocol = uri.substring(0, position - 1);
        String location = uri.substring(position + 2);
        Request request = ObjectModelHelper.getRequest(objectModel);
        Object obj = request.get(location);
        if (!(obj instanceof Part)) {
            throw new SourceException("Request object " + location + " is not an uploaded Part");
        }
        this.part = (Part)obj;
    }

    public InputStream getInputStream() throws IOException, SourceNotFoundException {
        try {
            return this.part.getInputStream();
        }
        catch (Exception ex) {
            throw new SourceNotFoundException("The part source can not be found.");
        }
    }

    public String getMimeType() {
        return this.part.getMimeType();
    }

    public boolean exists() {
        return this.part != null;
    }

    public String getURI() {
        return this.uri;
    }

    public String getScheme() {
        return this.protocol;
    }

    public SourceValidity getValidity() {
        return null;
    }

    public void refresh() {
    }

    public long getContentLength() {
        return this.part.getSize();
    }

    public long getLastModified() {
        return 0L;
    }

    public Part getPart() {
        return this.part;
    }
}

