/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.ITypeNameRequestor;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.IJavaElementRequestor;
import org.eclipse.jdt.internal.core.JarPackageFragment;
import org.eclipse.jdt.internal.core.JavaElementRequestor;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SingleTypeRequestor;
import org.eclipse.jdt.internal.core.util.Util;

public class NameLookup
implements SuffixConstants {
    public static final int ACCEPT_CLASSES = 2;
    public static final int ACCEPT_INTERFACES = 4;
    protected IPackageFragmentRoot[] packageFragmentRoots;
    protected Map packageFragments;
    protected HashMap unitsToLookInside;

    public NameLookup(IPackageFragmentRoot[] packageFragmentRoots, HashMap packageFragments, ICompilationUnit[] workingCopies) {
        this.packageFragmentRoots = packageFragmentRoots;
        this.packageFragments = packageFragments;
        if (workingCopies != null) {
            this.unitsToLookInside = new HashMap();
            int i = 0;
            int length = workingCopies.length;
            while (i < length) {
                ICompilationUnit unitToLookInside = workingCopies[i];
                ICompilationUnit original = unitToLookInside.getPrimary();
                this.unitsToLookInside.put(original, unitToLookInside);
                ++i;
            }
        }
    }

    protected boolean acceptType(IType type, int acceptFlags) {
        if (acceptFlags == 0 || acceptFlags == 6) {
            return true;
        }
        try {
            if (type.isClass()) {
                return (acceptFlags & 2) != 0;
            }
            return (acceptFlags & 4) != 0;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private void findAllTypes(String prefix, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        int count = this.packageFragmentRoots.length;
        int i = 0;
        while (i < count) {
            block7: {
                if (requestor.isCanceled()) {
                    return;
                }
                IPackageFragmentRoot root = this.packageFragmentRoots[i];
                IJavaElement[] packages = null;
                try {
                    packages = root.getChildren();
                }
                catch (JavaModelException javaModelException) {
                    break block7;
                }
                if (packages != null) {
                    int j = 0;
                    int packageCount = packages.length;
                    while (j < packageCount) {
                        if (requestor.isCanceled()) {
                            return;
                        }
                        this.seekTypes(prefix, (IPackageFragment)packages[j], partialMatch, acceptFlags, requestor);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public ICompilationUnit findCompilationUnit(String qualifiedTypeName) {
        String pkgName = "";
        String cuName = qualifiedTypeName;
        int index = qualifiedTypeName.lastIndexOf(46);
        if (index != -1) {
            pkgName = qualifiedTypeName.substring(0, index);
            cuName = qualifiedTypeName.substring(index + 1);
        }
        if ((index = cuName.indexOf(36)) != -1) {
            cuName = cuName.substring(0, index);
        }
        cuName = String.valueOf(cuName) + ".java";
        IPackageFragment[] frags = (IPackageFragment[])this.packageFragments.get(pkgName);
        if (frags != null) {
            int i = 0;
            while (i < frags.length) {
                ICompilationUnit cu;
                IPackageFragment frag = frags[i];
                if (!(frag instanceof JarPackageFragment) && (cu = frag.getCompilationUnit(cuName)) != null && cu.exists()) {
                    return cu;
                }
                ++i;
            }
        }
        return null;
    }

    public IPackageFragment findPackageFragment(IPath path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException(Util.bind("path.mustBeAbsolute"));
        }
        IResource possibleFragment = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (possibleFragment == null) {
            int i = 0;
            while (i < this.packageFragmentRoots.length) {
                block21: {
                    IPath rootPath;
                    int matchingCount;
                    IPackageFragmentRoot root = this.packageFragmentRoots[i];
                    if (root.isExternal() && (matchingCount = (rootPath = root.getPath()).matchingFirstSegments(path)) != 0) {
                        String name = path.toOSString();
                        name = name.substring(rootPath.toOSString().length() + 1, name.length());
                        name = name.replace(File.separatorChar, '.');
                        IJavaElement[] list = null;
                        try {
                            list = root.getChildren();
                        }
                        catch (JavaModelException javaModelException) {
                            break block21;
                        }
                        int elementCount = list.length;
                        int j = 0;
                        while (j < elementCount) {
                            IPackageFragment packageFragment = (IPackageFragment)list[j];
                            if (this.nameMatches(name, packageFragment, false)) {
                                return packageFragment;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        } else {
            IJavaElement fromFactory = JavaCore.create(possibleFragment);
            if (fromFactory == null) {
                return null;
            }
            switch (fromFactory.getElementType()) {
                case 4: {
                    return (IPackageFragment)fromFactory;
                }
                case 2: {
                    JavaProject project = (JavaProject)fromFactory;
                    try {
                        IClasspathEntry entry = project.getClasspathEntryFor(path);
                        if (entry != null) {
                            IPackageFragmentRoot root = project.getPackageFragmentRoot(project.getResource());
                            IPackageFragment[] pkgs = (IPackageFragment[])this.packageFragments.get("");
                            if (pkgs == null) {
                                return null;
                            }
                            int i = 0;
                            while (i < pkgs.length) {
                                if (pkgs[i].getParent().equals(root)) {
                                    return pkgs[i];
                                }
                                ++i;
                            }
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        return null;
                    }
                    return null;
                }
                case 3: {
                    return ((IPackageFragmentRoot)fromFactory).getPackageFragment("");
                }
            }
        }
        return null;
    }

    public IPackageFragment[] findPackageFragments(String name, boolean partialMatch) {
        if (partialMatch) {
            String prefix = name.toLowerCase();
            ArrayList<IPackageFragment> pkgs = null;
            Iterator keys = this.packageFragments.keySet().iterator();
            while (keys.hasNext()) {
                String pkgName = (String)keys.next();
                if (!pkgName.toLowerCase().startsWith(prefix)) continue;
                IPackageFragment[] fragments = (IPackageFragment[])this.packageFragments.get(pkgName);
                int i = 0;
                int length = fragments == null ? 0 : fragments.length;
                while (i < length) {
                    if (pkgs == null) {
                        pkgs = new ArrayList<IPackageFragment>();
                    }
                    pkgs.add(fragments[i]);
                    ++i;
                }
            }
            if (pkgs == null) {
                return null;
            }
            int resultLength = pkgs.size();
            IPackageFragment[] result = new IPackageFragment[resultLength];
            pkgs.toArray(result);
            return result;
        }
        return (IPackageFragment[])this.packageFragments.get(name);
    }

    public IType findType(String typeName, String packageName, boolean partialMatch, int acceptFlags) {
        if (packageName == null || packageName.length() == 0) {
            packageName = "";
        } else if (typeName.length() > 0 && Character.isLowerCase(typeName.charAt(0)) && this.findPackageFragments(String.valueOf(packageName) + "." + typeName, false) != null) {
            return null;
        }
        JavaElementRequestor elementRequestor = new JavaElementRequestor();
        this.seekPackageFragments(packageName, false, elementRequestor);
        IPackageFragment[] packages = elementRequestor.getPackageFragments();
        int i = 0;
        int length = packages.length;
        while (i < length) {
            IType type = this.findType(typeName, packages[i], partialMatch, acceptFlags);
            if (type != null) {
                return type;
            }
            ++i;
        }
        return null;
    }

    public IType findType(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags) {
        if (pkg == null) {
            return null;
        }
        SingleTypeRequestor typeRequestor = new SingleTypeRequestor();
        this.seekTypes(name, pkg, partialMatch, acceptFlags, typeRequestor);
        IType type = typeRequestor.getType();
        return type;
    }

    IType findSecondaryType(String typeName, IPackageFragment pkg, boolean partialMatch, final int acceptFlags) {
        try {
            final ArrayList paths = new ArrayList();
            ITypeNameRequestor nameRequestor = new ITypeNameRequestor(){

                public void acceptClass(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                    if ((acceptFlags & 2) != 0 && (enclosingTypeNames == null || enclosingTypeNames.length == 0)) {
                        paths.add(path);
                    }
                }

                public void acceptInterface(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                    if ((acceptFlags & 4) != 0 && (enclosingTypeNames == null || enclosingTypeNames.length == 0)) {
                        paths.add(path);
                    }
                }
            };
            int matchMode = partialMatch ? 1 : 0;
            int matchRule = !partialMatch ? matchMode | 8 : matchMode;
            new SearchEngine().searchAllTypeNames(pkg.getElementName().toCharArray(), typeName.toCharArray(), matchRule, 0, SearchEngine.createJavaSearchScope(new IJavaElement[]{pkg}, false), nameRequestor, 2, null);
            if (!paths.isEmpty()) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                int i = 0;
                int l = paths.size();
                while (i < l) {
                    String pathname = (String)paths.get(i);
                    if (org.eclipse.jdt.internal.compiler.util.Util.isJavaFileName(pathname)) {
                        IFile file = workspace.getRoot().getFile((IPath)new Path(pathname));
                        ICompilationUnit unit = JavaCore.createCompilationUnitFrom(file);
                        return unit.getType(typeName);
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (OperationCanceledException operationCanceledException) {}
        return null;
    }

    public IType findType(String name, boolean partialMatch, int acceptFlags) {
        int index = name.lastIndexOf(46);
        String className = null;
        String packageName = null;
        if (index == -1) {
            packageName = "";
            className = name;
        } else {
            packageName = name.substring(0, index);
            className = name.substring(index + 1);
        }
        return this.findType(className, packageName, partialMatch, acceptFlags);
    }

    protected boolean nameMatches(String searchName, IJavaElement element, boolean partialMatch) {
        if (partialMatch) {
            return element.getElementName().toLowerCase().startsWith(searchName);
        }
        return element.getElementName().equals(searchName);
    }

    public void seekPackageFragments(String name, boolean partialMatch, IJavaElementRequestor requestor) {
        block7: {
            block6: {
                if (!partialMatch) break block6;
                String prefix = name.toLowerCase();
                Iterator keys = this.packageFragments.keySet().iterator();
                while (keys.hasNext()) {
                    if (requestor.isCanceled()) {
                        return;
                    }
                    String pkgName = (String)keys.next();
                    if (!pkgName.toLowerCase().startsWith(prefix)) continue;
                    IPackageFragment[] pkgs = (IPackageFragment[])this.packageFragments.get(pkgName);
                    int i = 0;
                    int length = pkgs == null ? 0 : pkgs.length;
                    while (i < length) {
                        if (requestor.isCanceled()) {
                            return;
                        }
                        requestor.acceptPackageFragment(pkgs[i]);
                        ++i;
                    }
                }
                break block7;
            }
            IPackageFragment[] pkgs = (IPackageFragment[])this.packageFragments.get(name);
            if (pkgs == null) break block7;
            int i = 0;
            int length = pkgs.length;
            while (i < length) {
                if (requestor.isCanceled()) {
                    return;
                }
                requestor.acceptPackageFragment(pkgs[i]);
                ++i;
            }
        }
    }

    public void seekTypes(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        String matchName;
        String string = matchName = partialMatch ? name.toLowerCase() : name;
        if (matchName.indexOf(46) >= 0) {
            matchName = matchName.replace('.', '$');
        }
        if (pkg == null) {
            this.findAllTypes(matchName, partialMatch, acceptFlags, requestor);
            return;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)pkg.getParent();
        try {
            int packageFlavor = root.getKind();
            switch (packageFlavor) {
                case 2: {
                    this.seekTypesInBinaryPackage(matchName, pkg, partialMatch, acceptFlags, requestor);
                    break;
                }
                case 1: {
                    this.seekTypesInSourcePackage(matchName, pkg, partialMatch, acceptFlags, requestor);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            return;
        }
    }

    protected void seekTypesInBinaryPackage(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        IClassFile[] classFiles = null;
        try {
            classFiles = pkg.getClassFiles();
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        int length = classFiles.length;
        String unqualifiedName = name;
        int index = name.lastIndexOf(36);
        if (index != -1 && ((unqualifiedName = name.substring(index + 1, name.length())).length() > 0 && Character.isDigit(unqualifiedName.charAt(0)) || unqualifiedName.length() == 0)) {
            unqualifiedName = name;
        }
        String matchName = partialMatch ? name.toLowerCase() : name;
        int i = 0;
        while (i < length) {
            block10: {
                if (requestor.isCanceled()) {
                    return;
                }
                IClassFile classFile = classFiles[i];
                String elementName = classFile.getElementName();
                if (partialMatch) {
                    elementName = elementName.toLowerCase();
                }
                if (elementName.startsWith(matchName)) {
                    IType type = null;
                    try {
                        type = classFile.getType();
                    }
                    catch (JavaModelException javaModelException) {
                        break block10;
                    }
                    if ((!partialMatch || type.getElementName().length() > 0 && !Character.isDigit(type.getElementName().charAt(0))) && this.nameMatches(unqualifiedName, type, partialMatch) && this.acceptType(type, acceptFlags)) {
                        requestor.acceptType(type);
                    }
                }
            }
            ++i;
        }
    }

    protected void seekTypesInSourcePackage(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        int index;
        int workingCopiesSize;
        ICompilationUnit[] compilationUnits = null;
        try {
            compilationUnits = pkg.getCompilationUnits();
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        int length = compilationUnits.length;
        boolean[] isWorkingCopy = new boolean[length];
        if (this.unitsToLookInside != null && (workingCopiesSize = this.unitsToLookInside.size()) > 0) {
            HashMap temp = new HashMap(workingCopiesSize);
            temp.putAll(this.unitsToLookInside);
            int i = 0;
            while (i < length) {
                ICompilationUnit unit = compilationUnits[i];
                ICompilationUnit workingCopy = (ICompilationUnit)temp.remove(unit);
                if (workingCopy != null) {
                    compilationUnits[i] = workingCopy;
                    isWorkingCopy[i] = true;
                }
                ++i;
            }
            index = 0;
            Collection values = temp.values();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                ICompilationUnit workingCopy = (ICompilationUnit)iterator.next();
                if (!pkg.equals(workingCopy.getParent())) continue;
                if (index == 0) {
                    int valuesLength = values.size();
                    index = length;
                    ICompilationUnit[] iCompilationUnitArray = compilationUnits;
                    compilationUnits = new ICompilationUnit[length += valuesLength];
                    System.arraycopy(iCompilationUnitArray, 0, compilationUnits, 0, index);
                    boolean[] blArray = isWorkingCopy;
                    isWorkingCopy = new boolean[length];
                    System.arraycopy(blArray, 0, isWorkingCopy, 0, index);
                }
                isWorkingCopy[index] = true;
                compilationUnits[index++] = workingCopy;
            }
            if (index > 0 && index < length) {
                ICompilationUnit[] iCompilationUnitArray = compilationUnits;
                compilationUnits = new ICompilationUnit[index];
                System.arraycopy(iCompilationUnitArray, 0, compilationUnits, 0, index);
                boolean[] blArray = isWorkingCopy;
                isWorkingCopy = new boolean[index];
                System.arraycopy(blArray, 0, isWorkingCopy, 0, index);
                length = index;
            }
        }
        String matchName = name;
        index = name.indexOf(36);
        boolean potentialMemberType = false;
        String potentialMatchName = null;
        if (index != -1) {
            potentialMatchName = name.substring(0, index);
            potentialMemberType = true;
        }
        String unitName = partialMatch ? matchName.toLowerCase() : String.valueOf(matchName) + ".java";
        String potentialUnitName = null;
        if (potentialMemberType) {
            potentialUnitName = partialMatch ? potentialMatchName.toLowerCase() : String.valueOf(potentialMatchName) + ".java";
        }
        int i = 0;
        while (i < length) {
            block25: {
                IType type;
                int j;
                int typeLength;
                IType[] types;
                if (requestor.isCanceled()) {
                    return;
                }
                ICompilationUnit compilationUnit = compilationUnits[i];
                if (isWorkingCopy[i] && !potentialMemberType || this.nameMatches(unitName, compilationUnit, partialMatch)) {
                    types = null;
                    try {
                        types = compilationUnit.getTypes();
                    }
                    catch (JavaModelException javaModelException) {
                        break block25;
                    }
                    typeLength = types.length;
                    j = 0;
                    while (j < typeLength) {
                        if (requestor.isCanceled()) {
                            return;
                        }
                        type = types[j];
                        if (this.nameMatches(matchName, type, partialMatch) && this.acceptType(type, acceptFlags)) {
                            requestor.acceptType(type);
                        }
                        ++j;
                    }
                } else if (potentialMemberType && this.nameMatches(potentialUnitName, compilationUnit, partialMatch)) {
                    types = null;
                    try {
                        types = compilationUnit.getTypes();
                    }
                    catch (JavaModelException javaModelException) {
                        break block25;
                    }
                    typeLength = types.length;
                    j = 0;
                    while (j < typeLength) {
                        if (requestor.isCanceled()) {
                            return;
                        }
                        type = types[j];
                        if (this.nameMatches(potentialMatchName, type, partialMatch)) {
                            this.seekQualifiedMemberTypes(name.substring(index + 1, name.length()), type, partialMatch, requestor, acceptFlags);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    protected void seekQualifiedMemberTypes(String qualifiedName, IType type, boolean partialMatch, IJavaElementRequestor requestor, int acceptFlags) {
        if (type == null) {
            return;
        }
        IType[] types = null;
        try {
            types = type.getTypes();
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        String matchName = qualifiedName;
        int index = qualifiedName.indexOf(36);
        boolean nested = false;
        if (index != -1) {
            matchName = qualifiedName.substring(0, index);
            nested = true;
        }
        int length = types.length;
        int i = 0;
        while (i < length) {
            if (requestor.isCanceled()) {
                return;
            }
            IType memberType = types[i];
            if (this.nameMatches(matchName, memberType, partialMatch)) {
                if (nested) {
                    this.seekQualifiedMemberTypes(qualifiedName.substring(index + 1, qualifiedName.length()), memberType, partialMatch, requestor, acceptFlags);
                } else if (this.acceptType(memberType, acceptFlags)) {
                    requestor.acceptMemberType(memberType);
                }
            }
            ++i;
        }
    }
}

