/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;

public class Clinit
extends AbstractMethodDeclaration {
    public static final char[] ConstantPoolName = "<clinit>".toCharArray();
    private FieldBinding assertionSyntheticFieldBinding = null;
    private FieldBinding classLiteralSyntheticField = null;

    public Clinit(CompilationResult compilationResult) {
        super(compilationResult);
        this.modifiers = 0;
        this.selector = ConstantPoolName;
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext staticInitializerFlowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            ExceptionHandlingFlowContext clinitContext = new ExceptionHandlingFlowContext(staticInitializerFlowContext.parent, this, TypeConstants.NoExceptions, this.scope, FlowInfo.DEAD_END);
            this.needFreeReturn = flowInfo.isReachable();
            flowInfo = flowInfo.mergedWith(staticInitializerFlowContext.initsOnReturn);
            FieldBinding[] fields = this.scope.enclosingSourceType().fields();
            int i = 0;
            int count = fields.length;
            while (i < count) {
                FieldBinding field = fields[i];
                if (field.isStatic() && field.isFinal() && !flowInfo.isDefinitelyAssigned(fields[i])) {
                    this.scope.problemReporter().uninitializedBlankFinalField(field, this.scope.referenceType().declarationOf(field));
                }
                ++i;
            }
            staticInitializerFlowContext.checkInitializerExceptions(this.scope, clinitContext, flowInfo);
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        int clinitOffset = 0;
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            clinitOffset = classFile.contentsOffset;
            this.generateCode(classScope, classFile, clinitOffset);
        }
        catch (AbortMethod e) {
            if (e.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                try {
                    classFile.contentsOffset = clinitOffset;
                    --classFile.methodCount;
                    classFile.codeStream.wideMode = true;
                    this.generateCode(classScope, classFile, clinitOffset);
                }
                catch (AbortMethod abortMethod) {
                    classFile.contentsOffset = clinitOffset;
                    --classFile.methodCount;
                }
            }
            classFile.contentsOffset = clinitOffset;
            --classFile.methodCount;
        }
    }

    private void generateCode(ClassScope classScope, ClassFile classFile, int clinitOffset) {
        ConstantPool constantPool = classFile.constantPool;
        int constantPoolOffset = constantPool.currentOffset;
        int constantPoolIndex = constantPool.currentIndex;
        classFile.generateMethodInfoHeaderForClinit();
        int codeAttributeOffset = classFile.contentsOffset;
        classFile.generateCodeAttributeHeader();
        CodeStream codeStream = classFile.codeStream;
        this.resolve(classScope);
        codeStream.reset(this, classFile);
        TypeDeclaration declaringType = classScope.referenceContext;
        MethodScope staticInitializerScope = declaringType.staticInitializerScope;
        staticInitializerScope.computeLocalVariablePositions(0, codeStream);
        if (this.assertionSyntheticFieldBinding != null) {
            codeStream.generateClassLiteralAccessForType(classScope.enclosingSourceType(), this.classLiteralSyntheticField);
            codeStream.invokeJavaLangClassDesiredAssertionStatus();
            Label falseLabel = new Label(codeStream);
            codeStream.ifne(falseLabel);
            codeStream.iconst_1();
            Label jumpLabel = new Label(codeStream);
            codeStream.goto_(jumpLabel);
            falseLabel.place();
            codeStream.iconst_0();
            jumpLabel.place();
            codeStream.putstatic(this.assertionSyntheticFieldBinding);
        }
        if (declaringType.fields != null) {
            int i = 0;
            int max = declaringType.fields.length;
            while (i < max) {
                FieldDeclaration fieldDecl = declaringType.fields[i];
                if (fieldDecl.isStatic()) {
                    fieldDecl.generateCode(staticInitializerScope, codeStream);
                }
                ++i;
            }
        }
        if (codeStream.position == 0) {
            classFile.contentsOffset = clinitOffset;
            --classFile.methodCount;
            constantPool.resetForClinit(constantPoolIndex, constantPoolOffset);
        } else {
            if (this.needFreeReturn) {
                int oldPosition = codeStream.position;
                codeStream.return_();
                codeStream.updateLocalVariablesAttribute(oldPosition);
            }
            codeStream.recordPositionsFrom(0, declaringType.sourceStart);
            classFile.completeCodeAttributeForClinit(codeAttributeOffset);
        }
    }

    public boolean isClinit() {
        return true;
    }

    public boolean isInitializationMethod() {
        return true;
    }

    public boolean isStatic() {
        return true;
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
    }

    public StringBuffer print(int tab, StringBuffer output) {
        ASTNode.printIndent(tab, output).append("<clinit>()");
        this.printBody(tab + 1, output);
        return output;
    }

    public void resolve(ClassScope classScope) {
        this.scope = new MethodScope(classScope, classScope.referenceContext, true);
    }

    public void traverse(ASTVisitor visitor, ClassScope classScope) {
        visitor.visit(this, classScope);
        visitor.endVisit(this, classScope);
    }

    public void setAssertionSupport(FieldBinding assertionSyntheticFieldBinding) {
        this.assertionSyntheticFieldBinding = assertionSyntheticFieldBinding;
        SourceTypeBinding sourceType = this.scope.outerMostMethodScope().enclosingSourceType();
        this.classLiteralSyntheticField = sourceType.addSyntheticField(sourceType, (BlockScope)this.scope);
    }
}

