/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.EmptyNodeSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FilterEnumerator;
import com.icl.saxon.expr.IsLastExpression;
import com.icl.saxon.expr.NodeSetExpression;
import com.icl.saxon.expr.NodeSetIntent;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.PositionRange;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.functions.Last;
import com.icl.saxon.om.NodeEnumeration;

class FilterExpression
extends NodeSetExpression {
    private Expression start;
    private Expression filter;
    private int dependencies = -1;

    public FilterExpression(Expression expression, Expression expression2) {
        this.start = expression;
        this.filter = expression2;
    }

    public Expression simplify() throws XPathException {
        NodeSetIntent nodeSetIntent;
        PositionRange positionRange;
        this.start = this.start.simplify();
        this.filter = this.filter.simplify();
        if (this.start instanceof EmptyNodeSet) {
            return this.start;
        }
        if (this.filter instanceof Value && !(this.filter instanceof NumericValue)) {
            boolean bl = ((Value)this.filter).asBoolean();
            if (bl) {
                return this.start;
            }
            return new EmptyNodeSet();
        }
        if (this.filter instanceof Last) {
            this.filter = new IsLastExpression(true);
        }
        if (this.start instanceof NodeSetIntent && this.filter instanceof PositionRange && (positionRange = (PositionRange)this.filter).getMinPosition() == 2 && positionRange.getMaxPosition() == Integer.MAX_VALUE && (nodeSetIntent = (NodeSetIntent)this.start).getNodeSetExpression() instanceof FilterExpression) {
            PositionRange positionRange2;
            FilterExpression filterExpression = (FilterExpression)nodeSetIntent.getNodeSetExpression();
            if (filterExpression.filter instanceof PositionRange && (positionRange2 = (PositionRange)filterExpression.filter).getMaxPosition() == Integer.MAX_VALUE) {
                return new FilterExpression(filterExpression.start, new PositionRange(positionRange2.getMinPosition() + 1, Integer.MAX_VALUE));
            }
        }
        return this;
    }

    public NodeEnumeration enumerate(Context context, boolean bl) throws XPathException {
        int n = this.getDependencies();
        int n2 = 0;
        if ((n & 0x45) != 0) {
            n2 |= 0x45;
        }
        if (this.start.isContextDocumentNodeSet() && (n & 0x80) != 0) {
            n2 |= 0x80;
        }
        if (n2 != 0) {
            return this.reduce(n2, context).enumerate(context, bl);
        }
        if (!(bl || this.filter.getDataType() != 2 && this.filter.getDataType() != -1 && (this.filter.getDependencies() & 0x30) == 0)) {
            bl = true;
        }
        if (this.start instanceof SingletonNodeSet && !((SingletonNodeSet)this.start).isGeneralUseAllowed()) {
            throw new XPathException("To use a result tree fragment in a filter expression, either use exslt:node-set() or specify version='1.1'");
        }
        NodeEnumeration nodeEnumeration = this.start.enumerate(context, bl);
        if (!nodeEnumeration.hasMoreElements()) {
            return nodeEnumeration;
        }
        return new FilterEnumerator(nodeEnumeration, this.filter, context, false);
    }

    public int getDependencies() {
        if (this.dependencies == -1) {
            this.dependencies = this.start.getDependencies() | this.filter.getDependencies() & 0x45;
        }
        return this.dependencies;
    }

    public Expression reduce(int n, Context context) throws XPathException {
        if ((n & this.getDependencies()) != 0) {
            Expression expression = this.start.reduce(n, context);
            Expression expression2 = this.filter.reduce(n & 0x45, context);
            FilterExpression filterExpression = new FilterExpression(expression, expression2);
            filterExpression.setStaticContext(this.getStaticContext());
            return ((Expression)filterExpression).simplify();
        }
        return this;
    }

    public boolean isContextDocumentNodeSet() {
        return this.start.isContextDocumentNodeSet();
    }

    public void display(int n) {
        System.err.println(Expression.indent(n) + "filter");
        this.start.display(n + 1);
        this.filter.display(n + 1);
    }
}

