/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.excalibur.datasource.JdbcConnectionFactory;
import org.apache.avalon.excalibur.datasource.NoAvailableConnectionException;
import org.apache.avalon.excalibur.datasource.ResourceLimitingJdbcConnectionPool;
import org.apache.avalon.excalibur.pool.InstrumentedResourceLimitingPool;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.excalibur.instrument.AbstractLogEnabledInstrumentable;
import org.apache.excalibur.instrument.Instrumentable;

public class ResourceLimitingJdbcDataSource
extends AbstractLogEnabledInstrumentable
implements DataSourceComponent,
Disposable {
    private boolean m_configured;
    private boolean m_disposed;
    protected InstrumentedResourceLimitingPool m_pool;

    public Connection getConnection() throws SQLException {
        Poolable connection;
        if (!this.m_configured) {
            throw new IllegalStateException("Not Configured");
        }
        if (this.m_disposed) {
            throw new IllegalStateException("Already Disposed");
        }
        try {
            connection = this.m_pool.get();
            if (null == connection) {
                throw new SQLException("Could not return Connection");
            }
        }
        catch (SQLException e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Could not return Connection", (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Could not return Connection", (Throwable)e);
            }
            throw new NoAvailableConnectionException(e.getMessage());
        }
        return (Connection)connection;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        int l_max;
        String connectionClass;
        boolean autoCommit;
        boolean oradb;
        long trimInterval;
        long timeout;
        boolean blocking;
        boolean maxStrict;
        int max;
        boolean disableKeepAlive;
        String keepAlive;
        int keepAliveAge;
        String passwd;
        String user;
        String dburl;
        block14: {
            if (this.m_configured) {
                throw new IllegalStateException("Already Configured");
            }
            String driver = configuration.getChild("driver").getValue("");
            dburl = configuration.getChild("dburl").getValue(null);
            user = configuration.getChild("user").getValue(null);
            passwd = configuration.getChild("password").getValue(null);
            Configuration controller = configuration.getChild("pool-controller");
            keepAliveAge = controller.getChild("keep-alive").getAttributeAsInteger("age", 5000);
            keepAlive = controller.getChild("keep-alive").getValue("SELECT 1");
            disableKeepAlive = controller.getChild("keep-alive").getAttributeAsBoolean("disable", false);
            max = controller.getAttributeAsInteger("max", 3);
            maxStrict = controller.getAttributeAsBoolean("max-strict", true);
            blocking = controller.getAttributeAsBoolean("blocking", true);
            timeout = controller.getAttributeAsLong("timeout", 0L);
            trimInterval = controller.getAttributeAsLong("trim-interval", 60000L);
            oradb = controller.getAttributeAsBoolean("oradb", false);
            autoCommit = configuration.getChild("auto-commit").getValueAsBoolean(true);
            connectionClass = controller.getAttribute("connection-class", null);
            if (!"".equals(driver)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Loading new driver: " + driver);
                }
                try {
                    Class.forName(driver, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException cnfe) {
                    if (!this.getLogger().isWarnEnabled()) break block14;
                    this.getLogger().warn("Could not load driver: " + driver, (Throwable)cnfe);
                }
            }
        }
        if (max < 1) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Maximum number of connections specified must be at least 1.");
            }
            l_max = 1;
        } else {
            l_max = max;
        }
        if (disableKeepAlive) {
            keepAlive = null;
        }
        if (oradb) {
            keepAlive = "SELECT 1 FROM DUAL";
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("The oradb attribute is deprecated, please use thekeep-alive element instead.");
            }
        }
        JdbcConnectionFactory factory = new JdbcConnectionFactory(dburl, user, passwd, autoCommit, keepAlive, keepAliveAge, connectionClass);
        factory.enableLogging(this.getLogger());
        try {
            this.m_pool = new ResourceLimitingJdbcConnectionPool(factory, l_max, maxStrict, blocking, timeout, trimInterval, autoCommit);
            this.m_pool.enableLogging(this.getLogger());
            this.addChildInstrumentable((Instrumentable)this.m_pool);
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Error configuring ResourceLimitingJdbcDataSource", (Throwable)e);
            }
            throw new ConfigurationException("Error configuring ResourceLimitingJdbcDataSource", (Throwable)e);
        }
        this.m_configured = true;
    }

    public void dispose() {
        this.m_disposed = true;
        this.m_pool.dispose();
        this.m_pool = null;
    }
}

