/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.typeimpl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.DatatypeBuilder;
import org.apache.cocoon.forms.datatype.ValidationRule;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.validation.ValidationError;
import org.apache.cocoon.xml.AttributesImpl;
import org.outerj.expression.ExpressionContext;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractDatatype
implements Datatype {
    private List validationRules = new ArrayList();
    private boolean arrayType = false;
    private DatatypeBuilder builder;
    private Convertor convertor;
    private static final String DATATYPE_EL = "datatype";

    public ValidationError validate(Object value, ExpressionContext expressionContext) {
        Iterator validationRulesIt = this.validationRules.iterator();
        while (validationRulesIt.hasNext()) {
            ValidationRule validationRule = (ValidationRule)validationRulesIt.next();
            ValidationError result = validationRule.validate(value, expressionContext);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void addValidationRule(ValidationRule validationRule) {
        this.validationRules.add(validationRule);
    }

    public boolean isArrayType() {
        return this.arrayType;
    }

    protected void setArrayType(boolean arrayType) {
        this.arrayType = arrayType;
    }

    protected void setConvertor(Convertor convertor) {
        this.convertor = convertor;
    }

    protected void setBuilder(DatatypeBuilder builder) {
        this.builder = builder;
    }

    public Convertor getPlainConvertor() {
        return this.builder.getPlainConvertor();
    }

    public DatatypeBuilder getBuilder() {
        return this.builder;
    }

    public Convertor getConvertor() {
        return this.convertor;
    }

    public ConversionResult convertFromString(String value, Locale locale) {
        return this.getConvertor().convertFromString(value, locale, null);
    }

    public String convertToString(Object value, Locale locale) {
        return this.getConvertor().convertToString(value, locale, null);
    }

    public void generateSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("type", this.getDescriptiveName());
        contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", DATATYPE_EL, "fi:datatype", (Attributes)attrs);
        this.getConvertor().generateSaxFragment(contentHandler, locale);
        contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", DATATYPE_EL, "fi:datatype");
    }
}

