/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.excalibur.instrument.AbstractLogEnabledInstrumentable;
import org.apache.excalibur.instrument.Instrumentable;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManagerConnector;
import org.apache.excalibur.instrument.manager.http.FavIconHandler;
import org.apache.excalibur.instrument.manager.http.HTMLCreateSampleHandler;
import org.apache.excalibur.instrument.manager.http.HTMLGCHandler;
import org.apache.excalibur.instrument.manager.http.HTMLInstrumentHandler;
import org.apache.excalibur.instrument.manager.http.HTMLInstrumentManagerHandler;
import org.apache.excalibur.instrument.manager.http.HTMLInstrumentableHandler;
import org.apache.excalibur.instrument.manager.http.HTMLRootHandler;
import org.apache.excalibur.instrument.manager.http.HTMLSampleHandler;
import org.apache.excalibur.instrument.manager.http.HTMLSampleLeaseHandler;
import org.apache.excalibur.instrument.manager.http.SampleChartHandler;
import org.apache.excalibur.instrument.manager.http.XMLCreateSampleHandler;
import org.apache.excalibur.instrument.manager.http.XMLCreateSamplesHandler;
import org.apache.excalibur.instrument.manager.http.XMLGCHandler;
import org.apache.excalibur.instrument.manager.http.XMLInstrumentHandler;
import org.apache.excalibur.instrument.manager.http.XMLInstrumentManagerHandler;
import org.apache.excalibur.instrument.manager.http.XMLInstrumentableHandler;
import org.apache.excalibur.instrument.manager.http.XMLSampleHandler;
import org.apache.excalibur.instrument.manager.http.XMLSampleLeaseHandler;
import org.apache.excalibur.instrument.manager.http.XMLSampleLeasesHandler;
import org.apache.excalibur.instrument.manager.http.XMLSnapshotHandler;
import org.apache.excalibur.instrument.manager.http.XMLSnapshotsHandler;
import org.apache.excalibur.instrument.manager.http.server.AbstractHTTPURLHandler;
import org.apache.excalibur.instrument.manager.http.server.HTTPServer;

public class InstrumentManagerHTTPConnector
extends AbstractLogEnabledInstrumentable
implements DefaultInstrumentManagerConnector,
Configurable,
Startable {
    public static final int DEFAULT_PORT = 15080;
    public static final String ENCODING = "UTF-8";
    public static final String XML_BANNER = "<?xml version='1.0' encoding='UTF-8'?>";
    private DefaultInstrumentManager m_manager;
    private int m_port;
    private InetAddress m_bindAddr;
    private boolean m_xml;
    private boolean m_html;
    private int m_chartWidth;
    private int m_chartHeight;
    private boolean m_antialias;
    private int m_maxLeasedSamples;
    private int m_maxLeasedSampleSize;
    private long m_maxLeasedSampleLease;
    private boolean m_readOnly;
    private HTTPServer m_httpServer;

    public InstrumentManagerHTTPConnector() {
        this.setInstrumentableName("http");
    }

    public void setInstrumentManager(DefaultInstrumentManager manager) {
        this.m_manager = manager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_port = configuration.getAttributeAsInteger("port", 15080);
        String bindAddress = configuration.getChild("bind").getValue(null);
        try {
            if (null != bindAddress) {
                this.m_bindAddr = InetAddress.getByName(bindAddress);
            }
        }
        catch (UnknownHostException e) {
            throw new ConfigurationException("Unable to resolve the bind point: " + bindAddress, (Throwable)e);
        }
        this.m_xml = configuration.getAttributeAsBoolean("xml", true);
        this.m_html = configuration.getAttributeAsBoolean("html", true);
        this.m_chartWidth = configuration.getAttributeAsInteger("chart-width", 600);
        this.m_chartHeight = configuration.getAttributeAsInteger("chart-height", 120);
        this.m_antialias = configuration.getAttributeAsBoolean("antialias", false);
        int maxSamples = this.m_manager.getMaxLeasedSamples();
        this.m_maxLeasedSamples = Math.min(maxSamples, configuration.getAttributeAsInteger("max-leased-samples", maxSamples));
        int maxSize = this.m_manager.getMaxLeasedSampleSize();
        this.m_maxLeasedSampleSize = Math.min(maxSize, configuration.getAttributeAsInteger("max-leased-sample-size", maxSize));
        long maxLease = this.m_manager.getMaxLeasedSampleLease();
        this.m_maxLeasedSampleLease = Math.min(maxLease, 1000L * (long)configuration.getAttributeAsInteger("max-leased-sample-lease", (int)(maxLease / 1000L)));
        this.m_readOnly = configuration.getAttributeAsBoolean("read-only", false);
        String accessLogFile = configuration.getAttribute("access-log", null);
        this.m_httpServer = new HTTPServer(this.m_port, this.m_bindAddr);
        this.m_httpServer.enableLogging(this.getLogger().getChildLogger("server"));
        this.m_httpServer.setInstrumentableName("server");
        this.m_httpServer.setAccessLogFile(accessLogFile);
        this.addChildInstrumentable((Instrumentable)this.m_httpServer);
    }

    public void start() throws Exception {
        String nameBase;
        if (this.m_xml) {
            nameBase = "xml-";
            this.initAndRegisterHandler(new XMLInstrumentManagerHandler(this.m_manager, this), nameBase + "instrument-manager");
            this.initAndRegisterHandler(new XMLInstrumentableHandler(this.m_manager), nameBase + "instrumentable");
            this.initAndRegisterHandler(new XMLInstrumentHandler(this.m_manager), nameBase + "instrument");
            this.initAndRegisterHandler(new XMLSampleHandler(this.m_manager), nameBase + "sample");
            this.initAndRegisterHandler(new XMLSnapshotHandler(this.m_manager), nameBase + "snapshot");
            this.initAndRegisterHandler(new XMLSnapshotsHandler(this.m_manager), nameBase + "snapshots");
            if (!this.m_readOnly) {
                this.initAndRegisterHandler(new XMLSampleLeaseHandler(this.m_manager, this), nameBase + "sample-lease");
                this.initAndRegisterHandler(new XMLSampleLeasesHandler(this.m_manager, this), nameBase + "sample-leases");
                this.initAndRegisterHandler(new XMLCreateSampleHandler(this.m_manager, this), nameBase + "create-sample");
                this.initAndRegisterHandler(new XMLCreateSamplesHandler(this.m_manager, this), nameBase + "create-samples");
                this.initAndRegisterHandler(new XMLGCHandler(this.m_manager), nameBase + "gc");
            }
        }
        if (this.m_html) {
            nameBase = "html-";
            this.initAndRegisterHandler(new HTMLInstrumentManagerHandler(this.m_manager, this), nameBase + "instrument-manager");
            this.initAndRegisterHandler(new HTMLInstrumentableHandler(this.m_manager), nameBase + "instrumentable");
            this.initAndRegisterHandler(new HTMLInstrumentHandler(this.m_manager, this), nameBase + "instrument");
            this.initAndRegisterHandler(new HTMLSampleHandler(this.m_manager, this), nameBase + "sample");
            this.initAndRegisterHandler(new SampleChartHandler(this.m_manager, this.m_chartWidth, this.m_chartHeight, this.m_antialias), "sample-chart");
            this.initAndRegisterHandler(new FavIconHandler(), "favicon");
            if (!this.m_readOnly) {
                this.initAndRegisterHandler(new HTMLSampleLeaseHandler(this.m_manager, this), nameBase + "sample-lease");
                this.initAndRegisterHandler(new HTMLCreateSampleHandler(this.m_manager, this), nameBase + "create-sample");
                this.initAndRegisterHandler(new HTMLGCHandler(this.m_manager), nameBase + "gc");
            }
            this.initAndRegisterHandler(new HTMLRootHandler(this.m_manager), nameBase + "root");
        }
        this.getLogger().debug("Starting Instrument Manager HTTP Connector");
        this.m_httpServer.start();
        this.getLogger().info("Instrument Manager HTTP Connector listening on port: " + this.m_port);
    }

    public void stop() throws Exception {
        this.getLogger().debug("Stopping Instrument Manager HTTP Connector");
        this.m_httpServer.stop();
        this.m_httpServer = null;
    }

    int getMaxLeasedSamples() {
        return this.m_maxLeasedSamples;
    }

    int getMaxLeasedSampleSize() {
        return this.m_maxLeasedSampleSize;
    }

    long getMaxLeasedSampleLease() {
        return this.m_maxLeasedSampleLease;
    }

    boolean isReadOnly() {
        return this.m_readOnly;
    }

    private void initAndRegisterHandler(AbstractHTTPURLHandler handler, String name) throws Exception {
        handler.enableLogging(this.getLogger().getChildLogger(name));
        handler.setInstrumentableName(name);
        this.addChildInstrumentable((Instrumentable)handler);
        this.m_httpServer.registerHandler(handler);
    }
}

