/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.NoSuchInstrumentSampleException;
import org.apache.excalibur.instrument.manager.http.AbstractHTMLHandler;
import org.apache.excalibur.instrument.manager.http.InstrumentManagerHTTPConnector;
import org.apache.excalibur.instrument.manager.http.server.HTTPRedirect;

public class HTMLSampleLeaseHandler
extends AbstractHTMLHandler {
    private InstrumentManagerHTTPConnector m_connector;

    public HTMLSampleLeaseHandler(DefaultInstrumentManager manager, InstrumentManagerHTTPConnector connector) {
        super("/sample-lease.html", manager);
        this.m_connector = connector;
    }

    public void doGet(String path, Map parameters, PrintWriter out) throws IOException {
        InstrumentSampleDescriptor desc;
        String name = this.getParameter(parameters, "name");
        long lease = this.getLongParameter(parameters, "lease");
        String instrument = this.getParameter(parameters, "instrument", null);
        String chart = this.getParameter(parameters, "chart", null);
        try {
            desc = this.getInstrumentManager().locateInstrumentSampleDescriptor(name);
        }
        catch (NoSuchInstrumentSampleException e) {
            int pos = name.lastIndexOf(46);
            if (pos >= 0) {
                throw new HTTPRedirect("instrument.html?name=" + this.urlEncode(name.substring(0, pos)));
            }
            throw new HTTPRedirect("instrument-manager.html");
        }
        lease = Math.max(1L, Math.min(lease, this.m_connector.getMaxLeasedSampleLease()));
        if (this.getInstrumentManager().getLeaseSampleCount() >= this.m_connector.getMaxLeasedSamples()) {
            lease = 1L;
        }
        desc.extendLease(lease);
        if (instrument != null) {
            int pos = name.lastIndexOf(46);
            if (pos >= 0) {
                throw new HTTPRedirect("instrument.html?name=" + this.urlEncode(name.substring(0, pos)));
            }
            throw new HTTPRedirect("instrumentable.html");
        }
        throw new HTTPRedirect("sample.html?name=" + this.urlEncode(desc.getName()) + (chart == null ? "" : "&chart=true"));
    }
}

