/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.InstrumentSampleSnapshot;
import org.apache.excalibur.instrument.manager.NoSuchInstrumentSampleException;
import org.apache.excalibur.instrument.manager.http.AbstractHTMLHandler;
import org.apache.excalibur.instrument.manager.http.InstrumentManagerHTTPConnector;
import org.apache.excalibur.instrument.manager.http.server.HTTPRedirect;

public class HTMLSampleHandler
extends AbstractHTMLHandler {
    private InstrumentManagerHTTPConnector m_connector;

    public HTMLSampleHandler(DefaultInstrumentManager manager, InstrumentManagerHTTPConnector connector) {
        super("/sample.html", manager);
        this.m_connector = connector;
    }

    public void doGet(String path, Map parameters, PrintWriter out) throws IOException {
        String type;
        InstrumentSampleDescriptor desc;
        String name = this.getParameter(parameters, "name");
        try {
            desc = this.getInstrumentManager().locateInstrumentSampleDescriptor(name);
        }
        catch (NoSuchInstrumentSampleException e) {
            int pos = name.lastIndexOf(46);
            if (pos >= 0) {
                throw new HTTPRedirect("instrument.html?name=" + this.urlEncode(name.substring(0, pos)));
            }
            throw new HTTPRedirect("instrument-manager.html");
        }
        String chart = this.getParameter(parameters, "chart", null);
        InstrumentSampleSnapshot snapshot = desc.getSnapshot();
        switch (desc.getType()) {
            case 101: {
                type = "Counter";
                break;
            }
            case 103: {
                type = "Max Value";
                break;
            }
            case 102: {
                type = "Min Value";
                break;
            }
            case 104: {
                type = "Mean Value";
                break;
            }
            default: {
                type = "Unknown";
            }
        }
        out.println("<html>");
        out.println("<head><title>" + desc.getDescription() + "</title></head>");
        out.println("<body>");
        this.breadCrumbs(out, desc, false);
        out.println("<h2>Instrument Sample</h2>");
        this.startTable(out);
        this.tableRow(out, 0, "Name", desc.getName());
        this.tableRow(out, 0, "Description", desc.getDescription());
        this.tableRow(out, 0, "Type", type);
        this.tableRow(out, 0, "Interval", desc.getInterval() + "ms.");
        this.tableRow(out, 0, "Size", Integer.toString(desc.getSize()));
        if (desc.getLeaseExpirationTime() > 0L) {
            String renewUrl = "sample-lease.html?name=" + this.urlEncode(desc.getName()) + (chart == null ? "" : "&chart=true") + "&lease=";
            String value = new Date(desc.getLeaseExpirationTime()).toString();
            if (!this.m_connector.isReadOnly()) {
                value = value + " (Renew <a href='" + renewUrl + "600000'>10min</a>, " + "<a href='" + renewUrl + "3600000'>1hr</a>, " + "<a href='" + renewUrl + "86400000'>1day</a>)";
            }
            if (desc.getLeaseExpirationTime() - System.currentTimeMillis() < 300000L) {
                value = "<font color='ff0000'>" + value + "</font>";
            }
            this.tableRow(out, 0, "Expiration", value);
        } else {
            this.tableRow(out, 0, "Expiration", "Permanent");
        }
        this.endTable(out);
        if (chart == null) {
            out.println("<h2>Data Samples (<a href='sample.html?name=" + this.urlEncode(desc.getName()) + "&chart=true'>Chart</a>)</h2>");
            this.startTable(out);
            this.startTableHeaderRow(out);
            this.tableHeaderCell(out, "Period");
            this.tableHeaderCell(out, "Value");
            this.endTableHeaderRow(out);
            long time = snapshot.getTime();
            int[] samples = snapshot.getSamples();
            for (int i = 0; i < samples.length; ++i) {
                this.startTableRow(out, i);
                this.tableCell(out, new Date(time).toString());
                this.tableCellRight(out, Integer.toString(samples[samples.length - i - 1]));
                this.endTableRow(out);
                time -= snapshot.getInterval();
            }
            this.endTable(out);
        } else {
            out.println("<h2>Data Samples (<a href='sample.html?name=" + this.urlEncode(desc.getName()) + "'>Plain</a>)</h2>");
            out.println("<SCRIPT LANGUAGE=\"JavaScript\">");
            out.println("var timerId = 0;");
            out.println("var timerInterval = 5000;");
            out.println("function refreshChart() {");
            out.println("  document.chart.src=\"sample-chart.jpg?name=" + this.urlEncode(desc.getName()) + "&time=\" + new Date().getTime();");
            out.println("}");
            out.println("function timerFired() {");
            out.println("  if (timerId) {");
            out.println("    clearTimeout(timerId);");
            out.println("  }");
            out.println("  timerId = setTimeout(\"timerFired()\", timerInterval)");
            out.println("  refreshChart();");
            out.println("}");
            out.println("function setRefresh(refresh) {");
            out.println("  timerInterval = refresh;");
            out.println("  timerFired();");
            out.println("}");
            out.println("function chartError() {");
            out.println("  clearTimeout(timerId);");
            out.println("  document.location=\"instrument.html?name=" + this.urlEncode(desc.getInstrumentDescriptor().getName()) + "\";");
            out.println("}");
            out.println("</SCRIPT>");
            out.println("<form>");
            this.startTable(out);
            this.tableCell(out, "<img name='chart' src='sample-chart.jpg?name=" + this.urlEncode(desc.getName()) + "&time=" + System.currentTimeMillis() + "' onError='javascript:chartError()'>");
            this.endTable(out);
            out.println("Refresh rate:");
            out.println("<input type='button' value='No Refresh' onClick='javascript:clearTimeout(timerId)'>");
            out.println("<input type='button' value='1 Second' onClick='javascript:setRefresh(1000)'>");
            out.println("<input type='button' value='5 Seconds' onClick='javascript:setRefresh(5000)'>");
            out.println("<input type='button' value='10 Seconds' onClick='javascript:setRefresh(10000)'>");
            out.println("<input type='button' value='1 Minute' onClick='javascript:setRefresh(60000)'>");
            out.println("<input type='button' value='Refresh Now' onClick='javascript:refreshChart()'>");
            out.println("</form>");
        }
        this.footer(out);
        out.println("</body>");
        out.println("</html>");
    }
}

