/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.extensions;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.render.afp.extensions.AFPPageSetup;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public abstract class AbstractAFPExtensionObject
extends FONode {
    private AFPPageSetup setupCode;
    private String name;

    public AbstractAFPExtensionObject(FONode parent, String name) {
        super(parent);
        this.name = name;
        this.setupCode = new AFPPageSetup(name);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI)) {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    protected void addCharacters(char[] data, int start, int end, PropertyList pList, Locator locator) {
        this.setupCode.setContent(new String(data, start, end - start));
    }

    public String getNamespaceURI() {
        return "http://xmlgraphics.apache.org/fop/extensions/afp";
    }

    public String getNormalNamespacePrefix() {
        return "afp";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processNode(String elementName, Locator locator, Attributes attlist, PropertyList propertyList) throws FOPException {
        String name = attlist.getValue("name");
        if (name == null || name.length() <= 0) {
            throw new FOPException(elementName + " must have a name attribute.");
        }
        this.setupCode.setName(name);
        if ("include-page-segment".equals(elementName)) {
            name = attlist.getValue("src");
            if (name == null || name.length() <= 0) throw new FOPException(elementName + " must have a src attribute.");
            this.setupCode.setValue(name);
            return;
        } else {
            if (!"tag-logical-element".equals(elementName)) return;
            name = attlist.getValue("value");
            if (name == null || name.length() <= 0) throw new FOPException(elementName + " must have a value attribute.");
            this.setupCode.setValue(name);
        }
    }

    protected void endOfNode() throws FOPException {
        super.endOfNode();
    }

    public ExtensionAttachment getExtensionAttachment() {
        return this.setupCode;
    }

    public String getLocalName() {
        return this.name;
    }
}

