/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral.socket.tcp;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.lateral.LateralCacheInfo;
import org.apache.jcs.auxiliary.lateral.LateralElementDescriptor;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheListener;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;

public class LateralTCPListener
implements ILateralCacheListener,
Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$lateral$socket$tcp$LateralTCPListener == null ? (class$org$apache$jcs$auxiliary$lateral$socket$tcp$LateralTCPListener = LateralTCPListener.class$("org.apache.jcs.auxiliary.lateral.socket.tcp.LateralTCPListener")) : class$org$apache$jcs$auxiliary$lateral$socket$tcp$LateralTCPListener));
    private static final int acceptTimeOut = 0;
    protected static transient CompositeCacheManager cacheMgr;
    protected static final HashMap instances;
    private ListenerThread receiver;
    private ILateralCacheAttributes ilca;
    private int port;
    private PooledExecutor pooledExecutor = new PooledExecutor();
    private int putCnt = 0;
    private int removeCnt = 0;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$lateral$socket$tcp$LateralTCPListener;

    public static synchronized ILateralCacheListener getInstance(ILateralCacheAttributes ilca) {
        ILateralCacheListener ins = (ILateralCacheListener)instances.get(String.valueOf(ilca.getTcpListenerPort()));
        if (ins == null) {
            ins = new LateralTCPListener(ilca);
            ins.init();
            instances.put(String.valueOf(ilca.getTcpListenerPort()), ins);
            if (log.isDebugEnabled()) {
                log.debug((Object)("created new listener " + ilca.getTcpListenerPort()));
            }
        }
        return ins;
    }

    protected LateralTCPListener(ILateralCacheAttributes ilca) {
        this.ilca = ilca;
    }

    public void init() {
        try {
            this.port = this.ilca.getTcpListenerPort();
            this.receiver = new ListenerThread();
            this.receiver.start();
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public void setListenerId(long id) throws IOException {
        LateralCacheInfo.listenerId = id;
        if (log.isDebugEnabled()) {
            log.debug((Object)("set listenerId = " + id));
        }
    }

    public long getListenerId() throws IOException {
        return LateralCacheInfo.listenerId;
    }

    public void handlePut(ICacheElement element) throws IOException {
        ++this.putCnt;
        if (log.isInfoEnabled() && this.putCnt % 100 == 0) {
            log.info((Object)("Put Count = " + this.putCnt));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("handlePut> cacheName=" + element.getCacheName() + ", key=" + element.getKey()));
        }
        this.getCache(element.getCacheName()).localUpdate(element);
    }

    public void handleRemove(String cacheName, Serializable key) throws IOException {
        ++this.removeCnt;
        if (log.isInfoEnabled() && this.removeCnt % 100 == 0) {
            log.info((Object)("Remove Count = " + this.removeCnt));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleRemove> cacheName=" + cacheName + ", key=" + key));
        }
        this.getCache(cacheName).localRemove(key);
    }

    public void handleRemoveAll(String cacheName) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleRemoveAll> cacheName=" + cacheName));
        }
        this.getCache(cacheName).localRemoveAll();
    }

    public Serializable handleGet(String cacheName, Serializable key) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleGet> cacheName=" + cacheName + ", key = " + key));
        }
        return this.getCache(cacheName).localGet(key);
    }

    public void handleDispose(String cacheName) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleDispose> cacheName=" + cacheName));
        }
        CompositeCacheManager cm = cacheMgr;
        cm.freeCache(cacheName, true);
    }

    protected CompositeCache getCache(String name) {
        if (cacheMgr == null) {
            cacheMgr = CompositeCacheManager.getInstance();
            if (log.isDebugEnabled()) {
                log.debug((Object)("cacheMgr = " + cacheMgr));
            }
        }
        return cacheMgr.getCache(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        instances = new HashMap();
    }

    public class ConnectionHandler
    implements Runnable {
        private Socket socket;

        public ConnectionHandler(Socket socket) {
            this.socket = socket;
        }

        public void run() {
            ObjectInputStream ois;
            try {
                ois = new ObjectInputStream(this.socket.getInputStream());
            }
            catch (Exception e) {
                log.error((Object)("Could not open ObjectInputStream to " + this.socket), (Throwable)e);
                return;
            }
            try {
                while (true) {
                    LateralElementDescriptor led;
                    if ((led = (LateralElementDescriptor)ois.readObject()) == null) {
                        log.debug((Object)"LateralElementDescriptor is null");
                        continue;
                    }
                    if (led.requesterId == LateralCacheInfo.listenerId) {
                        log.debug((Object)"from self");
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("receiving LateralElementDescriptor from anotherled = " + led + ", led.command = " + led.command + ", led.ce = " + led.ce));
                    }
                    this.handle(led);
                }
            }
            catch (EOFException e) {
                log.info((Object)"Caught java.io.EOFException closing conneciton.");
            }
            catch (SocketException e) {
                log.info((Object)"Caught java.net.SocketException closing conneciton.");
            }
            catch (Exception e) {
                log.error((Object)"Unexpected exception. Closing conneciton", (Throwable)e);
            }
            try {
                ois.close();
            }
            catch (Exception e) {
                log.error((Object)"Could not close connection", (Throwable)e);
            }
        }

        private void handle(LateralElementDescriptor led) throws IOException {
            String cacheName = led.ce.getCacheName();
            Serializable key = led.ce.getKey();
            if (led.command == 1) {
                LateralTCPListener.this.handlePut(led.ce);
            } else if (led.command == 2) {
                LateralTCPListener.this.handleRemove(cacheName, key);
            } else if (led.command == 3) {
                LateralTCPListener.this.handleRemoveAll(cacheName);
            } else if (led.command == 5) {
                Serializable obj = LateralTCPListener.this.handleGet(cacheName, key);
                ObjectOutputStream oos = new ObjectOutputStream(this.socket.getOutputStream());
                if (oos != null) {
                    oos.writeObject(obj);
                    oos.flush();
                }
            }
        }
    }

    public class ListenerThread
    extends Thread {
        public void run() {
            try {
                log.info((Object)("Listening on port " + LateralTCPListener.this.port));
                ServerSocket serverSocket = new ServerSocket(LateralTCPListener.this.port);
                serverSocket.setSoTimeout(0);
                while (true) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Waiting for clients to connect ");
                    }
                    Socket socket = serverSocket.accept();
                    if (log.isDebugEnabled()) {
                        InetAddress inetAddress = socket.getInetAddress();
                        log.debug((Object)("Connected to client at " + inetAddress));
                    }
                    ConnectionHandler handler = new ConnectionHandler(socket);
                    LateralTCPListener.this.pooledExecutor.execute((Runnable)handler);
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception caught in TCP listener", (Throwable)e);
                return;
            }
        }
    }
}

