/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.AuxiliaryCacheManager;
import org.apache.jcs.auxiliary.lateral.LateralCache;
import org.apache.jcs.auxiliary.lateral.LateralCacheMonitor;
import org.apache.jcs.auxiliary.lateral.LateralCacheNoWait;
import org.apache.jcs.auxiliary.lateral.LateralCacheWatchRepairable;
import org.apache.jcs.auxiliary.lateral.ZombieLateralCacheService;
import org.apache.jcs.auxiliary.lateral.ZombieLateralCacheWatch;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheListener;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheObserver;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheService;
import org.apache.jcs.auxiliary.lateral.javagroups.LateralCacheJGListener;
import org.apache.jcs.auxiliary.lateral.javagroups.LateralJGService;
import org.apache.jcs.auxiliary.lateral.socket.tcp.LateralTCPListener;
import org.apache.jcs.auxiliary.lateral.socket.tcp.LateralTCPService;

public class LateralCacheManager
implements AuxiliaryCacheManager {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$lateral$LateralCacheManager == null ? (class$org$apache$jcs$auxiliary$lateral$LateralCacheManager = LateralCacheManager.class$("org.apache.jcs.auxiliary.lateral.LateralCacheManager")) : class$org$apache$jcs$auxiliary$lateral$LateralCacheManager));
    private static LateralCacheMonitor monitor;
    static final Map instances;
    final Map caches = new HashMap();
    protected ILateralCacheAttributes lca;
    private int clients;
    private ILateralCacheService lateralService;
    private LateralCacheWatchRepairable lateralWatch;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$lateral$LateralCacheManager;

    public static LateralCacheManager getInstance(ILateralCacheAttributes lca) {
        LateralCacheManager ins = (LateralCacheManager)instances.get(lca.toString());
        Map map = instances;
        synchronized (map) {
            if (ins == null) {
                log.info((Object)("Instance for [" + lca.toString() + "] is null, creating"));
                ins = (LateralCacheManager)instances.get(lca.toString());
                if (ins == null) {
                    ins = new LateralCacheManager(lca);
                    instances.put(lca.toString(), ins);
                }
            }
        }
        ++ins.clients;
        if (monitor == null && (monitor = LateralCacheMonitor.getInstance()) != null) {
            Thread t = new Thread(monitor);
            t.setDaemon(true);
            t.start();
        }
        return ins;
    }

    private LateralCacheManager(ILateralCacheAttributes lcaA) {
        this.lca = lcaA;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating lateral cache service, lca = " + this.lca));
        }
        try {
            if (this.lca.getTransmissionType() == 3) {
                log.debug((Object)"Creating TCP service");
                log.info((Object)("Creating TCP service, lca = " + this.lca));
                this.lateralService = new LateralTCPService(this.lca);
            } else if (this.lca.getTransmissionType() == 5) {
                log.debug((Object)"Creating JAVAGROUPS service");
                this.lateralService = new LateralJGService(this.lca);
            } else {
                log.error((Object)"Type not recognized, must zombie");
                throw new Exception("no known transmission type for lateral cache.");
            }
            if (this.lateralService == null) {
                log.error((Object)"No service created, must zombie");
                throw new Exception("no service created for lateral cache.");
            }
            this.lateralWatch = new LateralCacheWatchRepairable();
            this.lateralWatch.setCacheWatch(new ZombieLateralCacheWatch());
        }
        catch (Exception ex) {
            log.error((Object)"Failure, lateral instance will use zombie service", (Throwable)ex);
            this.lateralService = new ZombieLateralCacheService();
            this.lateralWatch = new LateralCacheWatchRepairable();
            this.lateralWatch.setCacheWatch(new ZombieLateralCacheWatch());
            LateralCacheMonitor.getInstance().notifyError();
        }
    }

    public void addLateralCacheListener(String cacheName, ILateralCacheListener listener) throws IOException {
        Map map = this.caches;
        synchronized (map) {
            this.lateralWatch.addCacheListener(cacheName, listener);
        }
    }

    public AuxiliaryCache getCache(String cacheName) {
        LateralCacheNoWait c = null;
        Map map = this.caches;
        synchronized (map) {
            c = (LateralCacheNoWait)this.caches.get(cacheName);
            if (c == null) {
                c = new LateralCacheNoWait(new LateralCache(this.lca, this.lateralService));
                this.caches.put(cacheName, c);
                log.info((Object)("craeted LateralCacheNoWait for " + this.lca));
            }
        }
        try {
            if (this.lca.getTransmissionType() == 3) {
                this.addLateralCacheListener(cacheName, LateralTCPListener.getInstance(this.lca));
            } else if (this.lca.getTransmissionType() == 5) {
                this.addLateralCacheListener(cacheName, LateralCacheJGListener.getInstance(this.lca));
            }
        }
        catch (IOException ioe) {
            log.error((Object)ioe);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return c;
    }

    public int getCacheType() {
        return 3;
    }

    public String getStats() {
        return "";
    }

    public void fixCaches(ILateralCacheService lateralService, ILateralCacheObserver lateralWatch) {
        log.debug((Object)"Fixing lateral caches:");
        Map map = this.caches;
        synchronized (map) {
            this.lateralService = lateralService;
            Iterator en = this.caches.values().iterator();
            while (en.hasNext()) {
                LateralCacheNoWait cache = (LateralCacheNoWait)en.next();
                cache.fixCache(this.lateralService);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        instances = new HashMap();
    }
}

