/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.coplet.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.aspect.AspectDataHandler;
import org.apache.cocoon.portal.aspect.AspectDataStore;
import org.apache.cocoon.portal.aspect.AspectDescription;
import org.apache.cocoon.portal.aspect.impl.DefaultAspectDataHandler;
import org.apache.cocoon.portal.aspect.impl.DefaultAspectDescription;
import org.apache.cocoon.portal.coplet.CopletData;
import org.apache.cocoon.portal.coplet.CopletFactory;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.portal.coplet.adapter.CopletAdapter;
import org.apache.cocoon.portal.coplet.impl.DefaultCopletDescription;

public class DefaultCopletFactory
extends AbstractLogEnabled
implements Component,
ThreadSafe,
CopletFactory,
Serviceable,
Disposable,
Configurable {
    protected ServiceManager manager;
    protected Map coplets = new HashMap();
    protected List descriptions = new ArrayList();
    protected ServiceSelector storeSelector;

    public void prepare(CopletData copletData) throws ProcessingException {
        if (copletData != null) {
            String copletName = copletData.getName();
            if (copletName == null) {
                throw new ProcessingException("CopletData " + copletData.getId() + " has no associated name.");
            }
            Object[] o = (Object[])this.coplets.get(copletName);
            if (o == null) {
                throw new ProcessingException("CopletDescription with name " + copletName + " not found.");
            }
            DefaultCopletDescription copletDescription = (DefaultCopletDescription)o[0];
            copletData.setDescription(copletDescription);
            copletData.setAspectDataHandler((AspectDataHandler)o[1]);
        }
    }

    public void prepare(CopletInstanceData copletInstanceData) throws ProcessingException {
        if (copletInstanceData != null) {
            String copletName = copletInstanceData.getName();
            if (copletName == null) {
                throw new ProcessingException("CopletInstanceData " + copletInstanceData.getId() + " has no associated name.");
            }
            Object[] o = (Object[])this.coplets.get(copletName);
            if (o == null) {
                throw new ProcessingException("CopletDescription with name " + copletName + " not found.");
            }
            DefaultCopletDescription copletDescription = (DefaultCopletDescription)o[0];
            copletInstanceData.setDescription(copletDescription);
            copletInstanceData.setAspectDataHandler((AspectDataHandler)o[2]);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CopletInstanceData newInstance(CopletData copletData) throws ProcessingException {
        ServiceSelector adapterSelector;
        CopletAdapter adapter;
        CopletInstanceData instance;
        block12: {
            String name = copletData.getName();
            Object[] o = (Object[])this.coplets.get(name);
            if (o == null) {
                throw new ProcessingException("CopletDescription with name " + name + " not found.");
            }
            DefaultCopletDescription copletDescription = (DefaultCopletDescription)o[0];
            instance = new CopletInstanceData();
            String id = null;
            if (copletDescription.createId()) {
                id = name + '-' + System.currentTimeMillis();
            }
            instance.initialize(name, id);
            instance.setDescription(copletDescription);
            instance.setAspectDataHandler((AspectDataHandler)o[2]);
            instance.setCopletData(copletData);
            String adapterName = copletData.getCopletBaseData().getCopletAdapterName();
            adapter = null;
            adapterSelector = null;
            adapterSelector = (ServiceSelector)this.manager.lookup(CopletAdapter.ROLE + "Selector");
            adapter = (CopletAdapter)adapterSelector.select((Object)adapterName);
            adapter.init(instance);
            adapter.login(instance);
            if (adapterSelector == null) break block12;
            adapterSelector.release((Object)adapter);
        }
        this.manager.release((Object)adapterSelector);
        PortalService service = null;
        try {
            try {
                service = (PortalService)this.manager.lookup(PortalService.ROLE);
                service.getComponentManager().getProfileManager().register(instance);
            }
            catch (ServiceException ce) {
                throw new ProcessingException("Unable to lookup profile manager.", (Throwable)ce);
            }
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.manager.release((Object)service);
            throw throwable;
        }
        catch (ServiceException ce) {
            try {
                throw new ProcessingException("Unable to lookup coplet adapter selector or adaptor.", (Throwable)ce);
            }
            catch (Throwable throwable) {
                if (adapterSelector != null) {
                    adapterSelector.release(adapter);
                }
                this.manager.release(adapterSelector);
                throw throwable;
            }
        }
        this.manager.release((Object)service);
        return instance;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.storeSelector = (ServiceSelector)this.manager.lookup(AspectDataStore.ROLE + "Selector");
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.storeSelector);
            this.storeSelector = null;
            this.manager = null;
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] copletsConf = configuration.getChild("coplets").getChildren("coplet");
        if (copletsConf != null) {
            int i = 0;
            while (i < copletsConf.length) {
                AspectDescription adesc;
                int m;
                DefaultCopletDescription desc = new DefaultCopletDescription();
                DefaultCopletDescription instanceDesc = new DefaultCopletDescription();
                String name = copletsConf[i].getAttribute("name");
                if (this.coplets.get(name) != null) {
                    throw new ConfigurationException("Coplet name must be unique. Double definition for " + name);
                }
                desc.setName(copletsConf[i].getAttribute("name"));
                instanceDesc.setName(copletsConf[i].getAttribute("name"));
                instanceDesc.setCreateId(copletsConf[i].getAttributeAsBoolean("create-id", true));
                Configuration[] aspectsConf = copletsConf[i].getChild("coplet-data-aspects").getChildren("aspect");
                if (aspectsConf != null) {
                    m = 0;
                    while (m < aspectsConf.length) {
                        adesc = DefaultAspectDescription.newInstance(aspectsConf[m]);
                        desc.addAspectDescription(adesc);
                        ++m;
                    }
                }
                if ((aspectsConf = copletsConf[i].getChild("coplet-instance-data-aspects").getChildren("aspect")) != null) {
                    m = 0;
                    while (m < aspectsConf.length) {
                        adesc = DefaultAspectDescription.newInstance(aspectsConf[m]);
                        instanceDesc.addAspectDescription(adesc);
                        ++m;
                    }
                }
                DefaultAspectDataHandler handler = new DefaultAspectDataHandler(desc, this.storeSelector);
                DefaultAspectDataHandler instanceHandler = new DefaultAspectDataHandler(instanceDesc, this.storeSelector);
                this.coplets.put(desc.getName(), new Object[]{desc, handler, instanceHandler});
                this.descriptions.add(desc);
                ++i;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(CopletInstanceData copletInstanceData) throws ProcessingException {
        ServiceSelector adapterSelector;
        CopletAdapter adapter;
        block10: {
            if (copletInstanceData == null) return;
            String adapterName = copletInstanceData.getCopletData().getCopletBaseData().getCopletAdapterName();
            adapter = null;
            adapterSelector = null;
            adapterSelector = (ServiceSelector)this.manager.lookup(CopletAdapter.ROLE + "Selector");
            adapter = (CopletAdapter)adapterSelector.select((Object)adapterName);
            adapter.logout(copletInstanceData);
            adapter.destroy(copletInstanceData);
            if (adapterSelector == null) break block10;
            adapterSelector.release((Object)adapter);
        }
        this.manager.release((Object)adapterSelector);
        PortalService service = null;
        try {
            try {
                service = (PortalService)this.manager.lookup(PortalService.ROLE);
                service.getComponentManager().getProfileManager().unregister(copletInstanceData);
            }
            catch (ServiceException ce) {
                throw new ProcessingException("Unable to lookup portal service.", (Throwable)ce);
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.manager.release((Object)service);
            throw throwable;
        }
        catch (ServiceException ce) {
            try {
                throw new ProcessingException("Unable to lookup coplet adapter selector or adaptor.", (Throwable)ce);
            }
            catch (Throwable throwable) {
                if (adapterSelector != null) {
                    adapterSelector.release(adapter);
                }
                this.manager.release(adapterSelector);
                throw throwable;
            }
        }
        this.manager.release((Object)service);
    }
}

