/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.portlet;

import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.WindowState;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.portlet.PortletCookie;
import org.apache.cocoon.environment.portlet.PortletEnvironment;
import org.apache.cocoon.environment.portlet.PortletSession;
import org.apache.cocoon.portlet.multipart.MultipartActionRequest;

public abstract class PortletRequest
implements Request {
    private String servletPath;
    private String pathInfo;
    private final javax.portlet.PortletRequest request;
    private final PortletEnvironment environment;
    private String form_encoding;
    private String container_encoding;
    private PortletSession session;
    private Cookie[] wrappedCookies = null;
    private Map wrappedCookieMap = null;
    protected String portletRequestURI;

    protected PortletRequest(String servletPath, String pathInfo, javax.portlet.PortletRequest request, PortletEnvironment environment) {
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.request = request;
        this.environment = environment;
    }

    public Object get(String name) {
        if (this.request instanceof MultipartActionRequest) {
            return ((MultipartActionRequest)this.request).get(name);
        }
        String[] values = this.request.getParameterValues(name);
        if (values == null) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        if (values.length > 1) {
            Vector<String> vect = new Vector<String>(values.length);
            int i = 0;
            while (i < values.length) {
                vect.add(values[i]);
                ++i;
            }
            return vect;
        }
        return null;
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    private synchronized void wrapCookies() {
        this.wrappedCookieMap = new HashMap();
        PortletPreferences cookies = this.request.getPreferences();
        if (cookies != null) {
            this.wrappedCookies = new Cookie[cookies.getMap().size()];
            int i = 0;
            Enumeration e = cookies.getNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                PortletCookie cookie = new PortletCookie(name, cookies.getValue(name, null));
                this.wrappedCookies[i] = cookie;
                this.wrappedCookieMap.put(cookie.getName(), cookie);
                ++i;
            }
        }
        this.wrappedCookieMap = Collections.unmodifiableMap(this.wrappedCookieMap);
    }

    public Cookie[] getCookies() {
        if (this.wrappedCookieMap == null) {
            this.wrapCookies();
        }
        return this.wrappedCookies;
    }

    public Map getCookieMap() {
        if (this.wrappedCookieMap == null) {
            this.wrapCookies();
        }
        return this.wrappedCookieMap;
    }

    public long getDateHeader(String name) {
        return Long.parseLong(this.request.getProperty(name));
    }

    public String getHeader(String name) {
        if ("X-Portlet-Mode".equals(name)) {
            return this.request.getPortletMode().toString();
        }
        if ("X-Window-State".equals(name)) {
            return this.request.getWindowState().toString();
        }
        return this.request.getProperty(name);
    }

    public Enumeration getHeaders(String name) {
        return this.request.getProperties(name);
    }

    public Enumeration getHeaderNames() {
        final Enumeration names = this.request.getPropertyNames();
        return new Enumeration(){
            int position;

            public boolean hasMoreElements() {
                return names.hasMoreElements() || this.position < 2;
            }

            public Object nextElement() throws NoSuchElementException {
                if (names.hasMoreElements()) {
                    return names.nextElement();
                }
                if (this.position == 0) {
                    ++this.position;
                    return "X-Portlet-Mode";
                }
                if (this.position == 1) {
                    ++this.position;
                    return "X-Window-State";
                }
                throw new NoSuchElementException();
            }
        };
    }

    public abstract String getMethod();

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getQueryString() {
        return "";
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getRequestURI() {
        if (this.portletRequestURI == null) {
            this.portletRequestURI = this.request.getContextPath();
        }
        return this.portletRequestURI;
    }

    public String getSitemapURI() {
        return this.environment.getURI();
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public Session getSession(boolean create) {
        javax.portlet.PortletSession serverSession = this.request.getPortletSession(create);
        if (null != serverSession) {
            if (null != this.session) {
                if (this.session.session != serverSession) {
                    this.session.session = serverSession;
                }
            } else {
                this.session = new PortletSession(serverSession);
            }
        } else {
            this.session = null;
        }
        return this.session;
    }

    public Session getSession() {
        return this.getSession(true);
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return true;
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.form_encoding;
    }

    public void setCharacterEncoding(String form_encoding) throws UnsupportedEncodingException {
        this.form_encoding = form_encoding;
    }

    public void setContainerEncoding(String container_encoding) {
        this.container_encoding = container_encoding;
    }

    public int getContentLength() {
        return -1;
    }

    public String getContentType() {
        return null;
    }

    public String getParameter(String name) {
        String value = this.request.getParameter(name);
        if (this.form_encoding == null || value == null) {
            return value;
        }
        return this.decode(value);
    }

    private String decode(String str) {
        if (str == null) {
            return null;
        }
        try {
            if (this.container_encoding == null) {
                this.container_encoding = "ISO-8859-1";
            }
            byte[] bytes = str.getBytes(this.container_encoding);
            return new String(bytes, this.form_encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new CascadingRuntimeException("Unsupported Encoding Exception", (Throwable)uee);
        }
    }

    public Enumeration getParameterNames() {
        return this.request.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        String[] values = this.request.getParameterValues(name);
        if (values == null) {
            return null;
        }
        if (this.form_encoding == null) {
            return values;
        }
        String[] decoded_values = new String[values.length];
        int i = 0;
        while (i < values.length) {
            decoded_values[i] = this.decode(values[i]);
            ++i;
        }
        return decoded_values;
    }

    public String getProtocol() {
        return "JSR168";
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public void setAttribute(String name, Object o) {
        this.request.setAttribute(name, o);
    }

    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration getLocales() {
        return this.request.getLocales();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public javax.portlet.PortletRequest getPortletRequest() {
        return this.request;
    }

    public Map getParameterMap() {
        return this.request.getParameterMap();
    }

    public PortalContext getPortalContext() {
        return this.request.getPortalContext();
    }

    public PortletMode getPortletMode() {
        return this.request.getPortletMode();
    }

    public javax.portlet.PortletSession getPortletSession() {
        return this.request.getPortletSession();
    }

    public javax.portlet.PortletSession getPortletSession(boolean create) {
        return this.request.getPortletSession(create);
    }

    public PortletPreferences getPreferences() {
        return this.request.getPreferences();
    }

    public Enumeration getProperties(String name) {
        return this.request.getProperties(name);
    }

    public String getProperty(String name) {
        return this.request.getProperty(name);
    }

    public Enumeration getPropertyNames() {
        return this.request.getPropertyNames();
    }

    public String getResponseContentType() {
        return this.request.getResponseContentType();
    }

    public Enumeration getResponseContentTypes() {
        return this.request.getResponseContentTypes();
    }

    public WindowState getWindowState() {
        return this.request.getWindowState();
    }

    public boolean isPortletModeAllowed(PortletMode mode) {
        return this.request.isPortletModeAllowed(mode);
    }

    public boolean isWindowStateAllowed(WindowState state) {
        return this.request.isWindowStateAllowed(state);
    }
}

