/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractInputModule;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.portlet.PortletObjectModelHelper;
import org.apache.cocoon.util.NetUtils;

public class PortletURLModule
extends AbstractInputModule
implements ThreadSafe {
    public static final String NAME_RENDER = "render";
    public static final String NAME_RESOURCE = "resource";
    public static final String NAME_ACTION = "action";
    private static final String PREFIX_RENDER = "render:";
    private static final String PREFIX_RESOURCE = "resource:";
    private static final String PREFIX_ACTION = "action:";
    private static final List returnNames;

    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        return returnNames.iterator();
    }

    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (name == null) {
            throw new NullPointerException("Attribute name is null");
        }
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        RenderResponse renderResponse = PortletObjectModelHelper.getRenderResponse(objectModel);
        if (renderResponse != null) {
            HashMap<String, String> parameters;
            PortletURL url = null;
            if (name.startsWith(PREFIX_RENDER)) {
                url = renderResponse.createRenderURL();
                if ((name = name.substring(PREFIX_RENDER.length())).length() > 0 && name.charAt(0) == '/') {
                    name = name.substring(1);
                }
            } else {
                if (name.startsWith(PREFIX_RESOURCE)) {
                    if ((name = name.substring(PREFIX_RESOURCE.length())).length() == 0 || name.charAt(0) != '/') {
                        String uri = request.getContextPath() + "/" + request.getServletPath();
                        name = NetUtils.absolutize((String)uri, (String)name);
                    }
                    return renderResponse.encodeURL(name);
                }
                if (name.startsWith(PREFIX_ACTION)) {
                    url = renderResponse.createActionURL();
                    if ((name = name.substring(PREFIX_ACTION.length())).length() > 0 && name.charAt(0) == '/') {
                        name = name.substring(1);
                    }
                } else {
                    throw new IllegalArgumentException("Invalid attribute name '" + name + "' for '" + ((Object)((Object)this)).getClass().getName() + "'");
                }
            }
            if ((name = NetUtils.deparameterize((String)name, parameters = new HashMap<String, String>(7))).length() > 0) {
                parameters.put("cocoon-portlet-path", name);
            }
            Iterator i = parameters.keySet().iterator();
            while (i.hasNext()) {
                String param = (String)i.next();
                Object values = parameters.get(param);
                if (values instanceof String) {
                    url.setParameter(param, (String)values);
                    continue;
                }
                url.setParameter(param, (String[])values);
            }
            return url.toString();
        }
        if (name.startsWith(PREFIX_RENDER)) {
            return name.substring(PREFIX_RENDER.length());
        }
        if (name.startsWith(PREFIX_RESOURCE)) {
            return name.substring(PREFIX_RESOURCE.length());
        }
        if (name.startsWith(PREFIX_ACTION)) {
            return name.substring(PREFIX_ACTION.length());
        }
        throw new IllegalArgumentException("Invalid attribute name '" + name + "' for '" + ((Object)((Object)this)).getClass().getName() + "'");
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Object result = this.getAttribute(name, modeConf, objectModel);
        if (result != null) {
            return new Object[]{result};
        }
        return null;
    }

    static {
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(NAME_RENDER);
        tmp.add(NAME_RESOURCE);
        tmp.add(NAME_ACTION);
        returnNames = tmp;
    }
}

