/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.components.source.InspectableSource;
import org.apache.cocoon.components.source.helpers.SourceProperty;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.URIException;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.ModifiableTraversableSource;
import org.apache.excalibur.source.MoveableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.TraversableSource;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;
import org.apache.webdav.lib.Property;
import org.apache.webdav.lib.PropertyName;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.WebdavResource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class WebDAVSource
extends AbstractLogEnabled
implements Source,
TraversableSource,
ModifiableSource,
ModifiableTraversableSource,
InspectableSource,
MoveableSource {
    private static final String NAMESPACE = "http://apache.org/cocoon/webdav/1.0";
    private static final String PREFIX = "webdav";
    private static final String RESOURCE_NAME = "resource";
    private static final String COLLECTION_NAME = "collection";
    private final HttpURL url;
    private final String protocol;
    private String uri;
    private String secureUri;
    private WebdavResource resource = null;
    private int depth = -1;
    private int action = -1;

    private WebDAVSource(HttpURL url, String protocol) throws URIException {
        this.protocol = protocol;
        this.url = url;
        String qs = url.getQuery();
        if (qs != null) {
            SourceParameters sp = new SourceParameters(qs);
            this.depth = sp.getParameterAsInteger("cocoon:webdav-depth", 1);
            this.action = sp.getParameterAsInteger("cocoon:webdav-action", 1);
            String principal = url.getUser();
            String password = url.getPassword();
            if (principal == null || password == null) {
                principal = sp.getParameter("cocoon:webdav-principal", principal);
                password = sp.getParameter("cocoon:webdav-password", password);
                if (principal != null) {
                    url.setUser(principal);
                    url.setPassword(password);
                }
            }
            sp.removeParameter("cocoon:webdav-depth");
            sp.removeParameter("cocoon:webdav-action");
            sp.removeParameter("cocoon:webdav-principal");
            sp.removeParameter("cocoon:webdav-password");
            url.setQuery(sp.getQueryString());
        }
    }

    private WebDAVSource(WebdavResource resource, HttpURL url, String protocol) throws URIException {
        this(url, protocol);
        this.resource = resource;
    }

    private void initResource(int action, int depth) throws SourceException, SourceNotFoundException {
        try {
            String path;
            boolean update = false;
            if (action != 1) {
                if (action > this.action) {
                    this.action = action;
                    update = true;
                } else {
                    action = this.action;
                }
            }
            if (depth > this.depth) {
                this.depth = depth;
                update = true;
            } else {
                depth = this.depth;
            }
            if (this.resource == null) {
                this.resource = new WebdavResource(this.url, action, depth);
            } else if (update) {
                this.resource.setProperties(action, depth);
            }
            if (this.action > 1 && this.resource.isCollection() && (path = this.url.getPath()).charAt(path.length() - 1) != '/') {
                this.url.setPath(path + "/");
            }
        }
        catch (HttpException e) {
            if (e.getReasonCode() == 404) {
                throw new SourceNotFoundException("Not found: " + this.getSecureURI(), (Throwable)e);
            }
            String msg = "Could not initialize webdav resource. Server responded " + e.getReasonCode() + " (" + e.getReason() + ") - " + e.getMessage();
            throw new SourceException(msg, (Throwable)e);
        }
        catch (IOException e) {
            throw new SourceException("Could not initialize webdav resource", (Throwable)e);
        }
    }

    public static WebDAVSource newWebDAVSource(HttpURL url, String protocol, Logger logger) throws URIException {
        WebDAVSource source = new WebDAVSource(url, protocol);
        source.enableLogging(logger);
        return source;
    }

    private static WebDAVSource newWebDAVSource(WebdavResource resource, HttpURL url, String protocol, Logger logger) throws URIException {
        WebDAVSource source = new WebDAVSource(resource, url, protocol);
        source.enableLogging(logger);
        return source;
    }

    public String getScheme() {
        return this.protocol;
    }

    public String getURI() {
        if (this.uri == null) {
            String userinfo;
            String uri = this.url.toString();
            int index = uri.indexOf("://");
            if (index != -1) {
                uri = uri.substring(index + 3);
            }
            uri = (userinfo = this.url.getEscapedUserinfo()) != null ? this.protocol + "://" + userinfo + "@" + uri : this.protocol + "://" + uri;
            this.uri = uri;
        }
        return this.uri;
    }

    protected String getSecureURI() {
        if (this.secureUri == null) {
            String uri = this.url.toString();
            int index = uri.indexOf("://");
            if (index != -1) {
                uri = uri.substring(index + 3);
            }
            this.secureUri = uri = this.protocol + "://" + uri;
        }
        return this.secureUri;
    }

    public SourceValidity getValidity() {
        long lm = this.getLastModified();
        if (lm > 0L) {
            return new TimeStampValidity(lm);
        }
        return null;
    }

    public void refresh() {
        this.resource = null;
    }

    public InputStream getInputStream() throws IOException, SourceException {
        this.initResource(3, 0);
        try {
            if (this.resource.isCollection()) {
                WebdavResource[] resources = this.resource.listWebdavResources();
                return this.resourcesToXml(resources);
            }
            BufferedInputStream bi = null;
            bi = new BufferedInputStream(this.resource.getMethodData());
            if (!this.resource.exists()) {
                throw new HttpException(this.getSecureURI() + " does not exist");
            }
            return bi;
        }
        catch (HttpException he) {
            throw new SourceException("Could not get WebDAV resource " + this.getSecureURI(), (Throwable)he);
        }
        catch (Exception e) {
            throw new SourceException("Could not get WebDAV resource" + this.getSecureURI(), (Throwable)e);
        }
    }

    public String getMimeType() {
        try {
            this.initResource(3, 0);
        }
        catch (IOException e) {
            return null;
        }
        return this.resource.getGetContentType();
    }

    public long getContentLength() {
        try {
            this.initResource(3, 0);
        }
        catch (IOException e) {
            return -1L;
        }
        if (this.resource.isCollection()) {
            return -1L;
        }
        return this.resource.getGetContentLength();
    }

    public long getLastModified() {
        try {
            this.initResource(3, 0);
        }
        catch (IOException e) {
            return 0L;
        }
        return this.resource.getGetLastModified();
    }

    public boolean exists() {
        try {
            this.initResource(3, 0);
        }
        catch (SourceNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return true;
        }
        return this.resource.getExistence();
    }

    private InputStream resourcesToXml(WebdavResource[] resources) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        TransformerHandler th = ((SAXTransformerFactory)tf).newTransformerHandler();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(bOut);
        th.setResult(result);
        th.startDocument();
        th.startPrefixMapping(PREFIX, NAMESPACE);
        th.startElement(NAMESPACE, COLLECTION_NAME, "webdav:collection", new AttributesImpl());
        this.resourcesToSax(resources, th);
        th.endElement(NAMESPACE, COLLECTION_NAME, "webdav:collection");
        th.endPrefixMapping(PREFIX);
        th.endDocument();
        return new ByteArrayInputStream(bOut.toByteArray());
    }

    private void resourcesToSax(WebdavResource[] resources, ContentHandler handler) throws SAXException {
        int i = 0;
        while (i < resources.length) {
            block12: {
                if (this.getLogger().isDebugEnabled()) {
                    String message = "RESOURCE: " + resources[i].getDisplayName();
                    this.getLogger().debug(message);
                }
                if (resources[i].isCollection()) {
                    try {
                        WebdavResource[] childs = resources[i].listWebdavResources();
                        AttributesImpl attrs = new AttributesImpl();
                        attrs.addAttribute(NAMESPACE, COLLECTION_NAME, "webdav:name", "CDATA", resources[i].getDisplayName());
                        handler.startElement(NAMESPACE, COLLECTION_NAME, "webdav:collection", attrs);
                        this.resourcesToSax(childs, handler);
                        handler.endElement(NAMESPACE, COLLECTION_NAME, "webdav:collection");
                    }
                    catch (HttpException e) {
                        if (this.getLogger().isDebugEnabled()) {
                            String message = "Unable to get WebDAV children. Server responded " + e.getReasonCode() + " (" + e.getReason() + ") - " + e.getMessage();
                            this.getLogger().debug(message);
                        }
                        break block12;
                    }
                    catch (SAXException e) {
                        if (this.getLogger().isDebugEnabled()) {
                            String message = "Unable to get WebDAV children: " + e.getMessage();
                            this.getLogger().debug(message, (Throwable)e);
                        }
                        break block12;
                    }
                    catch (IOException e) {
                        if (this.getLogger().isDebugEnabled()) {
                            String message = "Unable to get WebDAV children: " + e.getMessage();
                            this.getLogger().debug(message, (Throwable)e);
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        if (this.getLogger().isDebugEnabled()) {
                            String message = "Unable to get WebDAV children: " + e.getMessage();
                            this.getLogger().debug(message, (Throwable)e);
                        }
                        break block12;
                    }
                }
                AttributesImpl attrs = new AttributesImpl();
                attrs.addAttribute(NAMESPACE, "name", "webdav:name", "CDATA", resources[i].getDisplayName());
                handler.startElement(NAMESPACE, RESOURCE_NAME, "webdav:resource", attrs);
                handler.endElement(NAMESPACE, RESOURCE_NAME, "webdav:resource");
            }
            ++i;
        }
    }

    public Source getChild(String childName) throws SourceException {
        if (!this.isCollection()) {
            throw new SourceException(this.getSecureURI() + " is not a collection.");
        }
        try {
            Object childURL = this.url instanceof HttpsURL ? new HttpsURL((HttpsURL)this.url, childName) : new HttpURL(this.url, childName);
            return WebDAVSource.newWebDAVSource(childURL, this.protocol, this.getLogger());
        }
        catch (URIException e) {
            throw new SourceException("Failed to create child", (Throwable)e);
        }
    }

    public Collection getChildren() throws SourceException {
        this.initResource(3, 1);
        ArrayList<WebDAVSource> children = new ArrayList<WebDAVSource>();
        try {
            WebdavResource[] resources = this.resource.listWebdavResources();
            int i = 0;
            while (i < resources.length) {
                Object childURL = this.url instanceof HttpsURL ? new HttpsURL((HttpsURL)this.url, resources[i].getName()) : new HttpURL(this.url, resources[i].getName());
                WebDAVSource src = WebDAVSource.newWebDAVSource(resources[i], childURL, this.protocol, this.getLogger());
                src.enableLogging(this.getLogger());
                children.add(src);
                ++i;
            }
        }
        catch (HttpException e) {
            if (this.getLogger().isDebugEnabled()) {
                String message = "Unable to get WebDAV children. Server responded " + e.getReasonCode() + " (" + e.getReason() + ") - " + e.getMessage();
                this.getLogger().debug(message);
            }
            throw new SourceException("Failed to get WebDAV collection children.", (Throwable)e);
        }
        catch (SourceException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SourceException("Failed to get WebDAV collection children.", (Throwable)e);
        }
        return children;
    }

    public String getName() {
        try {
            this.initResource(1, 0);
        }
        catch (IOException e) {
            return "";
        }
        return this.resource.getName();
    }

    public Source getParent() throws SourceException {
        String path = this.isCollection() ? ".." : ".";
        try {
            Object parentURL = this.url instanceof HttpsURL ? new HttpsURL((HttpsURL)this.url, path) : new HttpURL(this.url, path);
            return WebDAVSource.newWebDAVSource(parentURL, this.protocol, this.getLogger());
        }
        catch (URIException e) {
            throw new SourceException("Failed to create parent", (Throwable)e);
        }
    }

    public boolean isCollection() {
        try {
            this.initResource(3, 0);
        }
        catch (IOException e) {
            return false;
        }
        return this.resource.isCollection();
    }

    public OutputStream getOutputStream() throws IOException {
        return new WebDAVSourceOutputStream(this);
    }

    public boolean canCancel(OutputStream stream) {
        WebDAVSourceOutputStream wsos;
        if (stream instanceof WebDAVSourceOutputStream && (wsos = (WebDAVSourceOutputStream)stream).source == this) {
            return wsos.canCancel();
        }
        throw new IllegalArgumentException("The stream is not associated to this source");
    }

    public void cancel(OutputStream stream) throws SourceException {
        WebDAVSourceOutputStream wsos;
        if (stream instanceof WebDAVSourceOutputStream && (wsos = (WebDAVSourceOutputStream)stream).source == this) {
            try {
                wsos.cancel();
            }
            catch (Exception e) {
                throw new SourceException("Failure cancelling Source", (Throwable)e);
            }
        }
        throw new IllegalArgumentException("The stream is not associated to this source");
    }

    public void delete() throws SourceException {
        this.initResource(1, 0);
        try {
            this.resource.deleteMethod();
        }
        catch (HttpException e) {
            throw new SourceException("Unable to delete source: " + this.getSecureURI(), (Throwable)e);
        }
        catch (IOException e) {
            throw new SourceException("Unable to delete source: " + this.getSecureURI(), (Throwable)e);
        }
    }

    public void makeCollection() throws SourceException {
        this.initResource(1, 0);
        if (this.resource.exists()) {
            return;
        }
        try {
            int status;
            if (!this.resource.mkcolMethod() && (status = this.resource.getStatusCode()) != 405) {
                String msg = "Unable to create collection " + this.getSecureURI() + ". Server responded " + this.resource.getStatusCode() + " (" + this.resource.getStatusMessage() + ")";
                throw new SourceException(msg);
            }
        }
        catch (HttpException e) {
            throw new SourceException("Unable to create collection(s) " + this.getSecureURI(), (Throwable)e);
        }
        catch (SourceException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SourceException("Unable to create collection(s)" + this.getSecureURI(), (Throwable)e);
        }
    }

    public SourceProperty[] getSourceProperties() throws SourceException {
        this.initResource(1, 0);
        Vector<SourceProperty> sourceproperties = new Vector<SourceProperty>();
        Enumeration props = null;
        Property prop = null;
        try {
            Enumeration responses = this.resource.propfindMethod(0);
            while (responses.hasMoreElements()) {
                ResponseEntity response = (ResponseEntity)responses.nextElement();
                props = response.getProperties();
                while (props.hasMoreElements()) {
                    prop = (Property)props.nextElement();
                    SourceProperty srcProperty = new SourceProperty(prop.getElement());
                    sourceproperties.addElement(srcProperty);
                }
            }
        }
        catch (Exception e) {
            throw new SourceException("Error getting properties", (Throwable)e);
        }
        SourceProperty[] sourcepropertiesArray = new SourceProperty[sourceproperties.size()];
        int i = 0;
        while (i < sourceproperties.size()) {
            sourcepropertiesArray[i] = (SourceProperty)sourceproperties.elementAt(i);
            ++i;
        }
        return sourcepropertiesArray;
    }

    public SourceProperty getSourceProperty(String namespace, String name) throws SourceException {
        this.initResource(1, 0);
        Vector<PropertyName> propNames = new Vector<PropertyName>(1);
        propNames.add(new PropertyName(namespace, name));
        Enumeration props = null;
        Property prop = null;
        try {
            Enumeration responses = this.resource.propfindMethod(0, propNames);
            while (responses.hasMoreElements()) {
                ResponseEntity response = (ResponseEntity)responses.nextElement();
                props = response.getProperties();
                if (!props.hasMoreElements()) continue;
                prop = (Property)props.nextElement();
                return new SourceProperty(prop.getElement());
            }
        }
        catch (Exception e) {
            throw new SourceException("Error getting property: " + name, (Throwable)e);
        }
        return null;
    }

    public void removeSourceProperty(String namespace, String name) throws SourceException {
        this.initResource(1, 0);
        try {
            this.resource.proppatchMethod(new PropertyName(namespace, name), "", false);
        }
        catch (Exception e) {
            throw new SourceException("Could not remove property ", (Throwable)e);
        }
    }

    public void setSourceProperty(SourceProperty sourceproperty) throws SourceException {
        this.initResource(1, 0);
        try {
            Node node = null;
            NodeList list = sourceproperty.getValue().getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i) instanceof Text && !"".equals(list.item(i).getNodeValue()) || list.item(i) instanceof Element) {
                    node = list.item(i);
                    break;
                }
                ++i;
            }
            Properties format = new Properties();
            format.put("method", "xml");
            format.put("omit-xml-declaration", "yes");
            String prop = XMLUtils.serializeNode((Node)node, (Properties)format);
            this.resource.proppatchMethod(new PropertyName(sourceproperty.getNamespace(), sourceproperty.getName()), prop, true);
        }
        catch (HttpException e) {
            String message = "Unable to set property. Server responded " + e.getReasonCode() + " (" + e.getReason() + ") - " + e.getMessage();
            this.getLogger().debug(message);
            throw new SourceException("Could not set property ", (Throwable)e);
        }
        catch (Exception e) {
            throw new SourceException("Could not set property ", (Throwable)e);
        }
    }

    public void moveTo(Source source) throws SourceException {
        if (source instanceof WebDAVSource) {
            WebDAVSource destination = (WebDAVSource)source;
            try {
                this.resource.moveMethod(destination.resource.getHttpURL().getPath());
            }
            catch (HttpException e) {
                throw new SourceException("Cannot move source '" + this.getSecureURI() + "'", (Throwable)e);
            }
            catch (IOException e) {
                throw new SourceException("Cannot move source '" + this.getSecureURI() + "'", (Throwable)e);
            }
        } else {
            SourceUtil.move((Source)this, (Source)source);
        }
    }

    public void copyTo(Source source) throws SourceException {
        if (source instanceof WebDAVSource) {
            WebDAVSource destination = (WebDAVSource)source;
            try {
                this.resource.copyMethod(destination.resource.getHttpURL().getPath());
            }
            catch (HttpException e) {
                throw new SourceException("Cannot copy source '" + this.getSecureURI() + "'", (Throwable)e);
            }
            catch (IOException e) {
                throw new SourceException("Cannot copy source '" + this.getSecureURI() + "'", (Throwable)e);
            }
        } else {
            SourceUtil.copy((Source)this, (Source)source);
        }
    }

    private static class WebDAVSourceOutputStream
    extends ByteArrayOutputStream {
        private WebDAVSource source = null;
        private boolean isClosed = false;

        private WebDAVSourceOutputStream(WebDAVSource source) {
            this.source = source;
        }

        public void close() throws IOException {
            if (!this.isClosed) {
                try {
                    try {
                        super.close();
                        this.source.initResource(1, 0);
                        this.source.resource.putMethod(this.toByteArray());
                    }
                    catch (HttpException he) {
                        String message = "Unable to close output stream. Server responded " + he.getReasonCode() + " (" + he.getReason() + ") - " + he.getMessage();
                        this.source.getLogger().debug(message);
                        throw new IOException(he.getMessage());
                    }
                    Object var4_1 = null;
                    this.isClosed = true;
                }
                catch (Throwable throwable) {
                    Object var4_2 = null;
                    this.isClosed = true;
                    throw throwable;
                }
            }
        }

        private boolean canCancel() {
            return !this.isClosed;
        }

        private void cancel() {
            if (this.isClosed) {
                throw new IllegalStateException("Cannot cancel: outputstream is already closed");
            }
            this.isClosed = true;
        }
    }
}

