/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.reading;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.xml.soap.SOAPException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.session.Session;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.transport.http.AxisHttpSession;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.axis.SoapServer;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.ServiceableReader;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class AxisRPCReader
extends ServiceableReader
implements Configurable,
Disposable {
    private SoapServer m_server;
    private boolean m_isDevelompent = false;

    public void configure(Configuration config) throws ConfigurationException {
        this.m_isDevelompent = config.getChild("development-stage").getValueAsBoolean(this.m_isDevelompent);
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this.m_server = (SoapServer)manager.lookup(SoapServer.ROLE);
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, IOException, SAXException {
        super.setup(resolver, objectModel, src, parameters);
        this.checkHTTPPost(objectModel);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("AxisRPCReader.setup() complete");
        }
    }

    private void checkHTTPPost(Map objectModel) throws ProcessingException {
        String method = ObjectModelHelper.getRequest((Map)objectModel).getMethod();
        if (!"POST".equalsIgnoreCase(method)) {
            throw new ProcessingException("Reader only supports HTTP-POST (supplied was " + method + ")");
        }
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        HttpServletRequest req = (HttpServletRequest)this.objectModel.get("httprequest");
        HttpServletResponse res = (HttpServletResponse)this.objectModel.get("httpresponse");
        ServletContext con = (ServletContext)this.objectModel.get("httpservletcontext");
        String soapAction = null;
        MessageContext msgContext = null;
        Message responseMsg = null;
        try {
            res.setBufferSize(8192);
            msgContext = this.m_server.createMessageContext(req, res, con);
            Message requestMsg = new Message((Object)req.getInputStream(), false, req.getHeader("Content-Type"), req.getHeader("Content-Location"));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Request message:\n" + this.messageToString(requestMsg));
            }
            msgContext.setRequestMessage(requestMsg);
            String url = HttpUtils.getRequestURL((HttpServletRequest)req).toString();
            msgContext.setProperty("transport.url", (Object)url);
            try {
                soapAction = this.getSoapAction(req);
                if (soapAction != null) {
                    msgContext.setUseSOAPAction(true);
                    msgContext.setSOAPActionURI(soapAction);
                }
                msgContext.setSession((Session)new AxisHttpSession(req));
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Invoking Axis Engine");
                }
                this.m_server.invoke(msgContext);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Return from Axis Engine");
                }
                if ((responseMsg = msgContext.getResponseMessage()) == null) {
                    throw new Exception("no response message");
                }
            }
            catch (AxisFault fault) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Axis Fault", (Throwable)fault);
                }
                this.processAxisFault(fault);
                this.configureResponseFromAxisFault(res, fault);
                responseMsg = msgContext.getResponseMessage();
                if (responseMsg == null) {
                    responseMsg = new Message((Object)fault);
                }
            }
            catch (Exception e) {
                responseMsg = msgContext.getResponseMessage();
                res.setStatus(500);
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Error during SOAP call", (Throwable)e);
                }
                if (responseMsg == null) {
                    AxisFault fault = AxisFault.makeFault((Exception)e);
                    this.processAxisFault(fault);
                    responseMsg = new Message((Object)fault);
                }
            }
        }
        catch (AxisFault fault) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Axis fault occured while perforing request", (Throwable)fault);
            }
            this.processAxisFault(fault);
            this.configureResponseFromAxisFault(res, fault);
            responseMsg = msgContext.getResponseMessage();
            if (responseMsg == null) {
                responseMsg = new Message((Object)fault);
            }
        }
        catch (Exception e) {
            throw new ProcessingException("Exception thrown while performing request", (Throwable)e);
        }
        if (responseMsg != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Sending response:\n" + this.messageToString(responseMsg));
            }
            this.sendResponse(this.getProtocolVersion(req), msgContext.getSOAPConstants(), res, responseMsg);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("AxisRPCReader.generate() complete");
        }
    }

    protected void processAxisFault(AxisFault fault) {
        Element runtimeException = fault.lookupFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
        if (runtimeException != null) {
            this.getLogger().info("AxisFault:", (Throwable)fault);
            fault.removeFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("AxisFault:", (Throwable)fault);
        }
        if (this.m_isDevelompent) {
            fault.removeFaultDetail(Constants.QNAME_FAULTDETAIL_STACKTRACE);
        }
    }

    private void configureResponseFromAxisFault(HttpServletResponse response, AxisFault fault) {
        int status = this.getHttpServletResponseStatus(fault);
        if (status == 401) {
            response.setHeader("WWW-Authenticate", "Basic realm=\"AXIS\"");
        }
        response.setStatus(status);
    }

    protected int getHttpServletResponseStatus(AxisFault af) {
        return af.getFaultCode().getLocalPart().startsWith("Server.Unauth") ? 401 : 500;
    }

    private void sendResponse(String clientVersion, SOAPConstants constants, HttpServletResponse res, Message responseMsg) throws AxisFault, IOException {
        if (responseMsg == null) {
            res.setStatus(204);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("No axis response, not sending one");
            }
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Returned Content-Type:" + responseMsg.getContentType(constants));
                this.getLogger().debug("Returned Content-Length:" + responseMsg.getContentLength());
            }
            try {
                res.setContentType(responseMsg.getContentType(constants));
                responseMsg.writeTo((OutputStream)res.getOutputStream());
            }
            catch (SOAPException e) {
                this.getLogger().error("Exception sending response", (Throwable)e);
            }
        }
        if (!res.isCommitted()) {
            res.flushBuffer();
        }
    }

    private String getSoapAction(HttpServletRequest req) throws AxisFault {
        String soapAction = req.getHeader("SOAPAction");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("HEADER_SOAP_ACTION:" + soapAction);
        }
        if (soapAction == null) {
            throw new AxisFault("Client.NoSOAPAction", "No SOAPAction header", null, null);
        }
        if (soapAction.length() == 0) {
            soapAction = req.getContextPath();
        }
        return soapAction;
    }

    private String getProtocolVersion(HttpServletRequest req) {
        String ver;
        int sindex;
        String ret = HTTPConstants.HEADER_PROTOCOL_V10;
        String prot = req.getProtocol();
        if (prot != null && -1 != (sindex = prot.indexOf(47)) && HTTPConstants.HEADER_PROTOCOL_V11.equals((ver = prot.substring(sindex + 1)).trim())) {
            ret = HTTPConstants.HEADER_PROTOCOL_V11;
        }
        return ret;
    }

    private String messageToString(Message msg) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)os);
            return ((Object)os).toString();
        }
        catch (Exception e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Warning, could not convert message (" + msg + ") into string", (Throwable)e);
            }
            return null;
        }
    }

    public void dispose() {
        this.manager.release((Object)this.m_server);
    }
}

