/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

final class SegmentInfo {
    static final int NO = -1;
    static final int YES = 1;
    static final int CHECK_DIR = 0;
    static final int WITHOUT_GEN = 0;
    public String name;
    public int docCount;
    public Directory dir;
    private boolean preLockless;
    private long delGen;
    private long[] normGen;
    private byte isCompoundFile;
    private boolean hasSingleNormFile;
    private List files;

    public SegmentInfo(String name, int docCount, Directory dir) {
        this.name = name;
        this.docCount = docCount;
        this.dir = dir;
        this.delGen = -1L;
        this.isCompoundFile = 0;
        this.preLockless = true;
        this.hasSingleNormFile = false;
    }

    public SegmentInfo(String name, int docCount, Directory dir, boolean isCompoundFile, boolean hasSingleNormFile) {
        this(name, docCount, dir);
        this.isCompoundFile = (byte)(isCompoundFile ? 1 : -1);
        this.hasSingleNormFile = hasSingleNormFile;
        this.preLockless = false;
    }

    void reset(SegmentInfo src) {
        this.files = null;
        this.name = src.name;
        this.docCount = src.docCount;
        this.dir = src.dir;
        this.preLockless = src.preLockless;
        this.delGen = src.delGen;
        if (src.normGen == null) {
            this.normGen = null;
        } else {
            this.normGen = new long[src.normGen.length];
            System.arraycopy(src.normGen, 0, this.normGen, 0, src.normGen.length);
        }
        this.isCompoundFile = src.isCompoundFile;
        this.hasSingleNormFile = src.hasSingleNormFile;
    }

    SegmentInfo(Directory dir, int format, IndexInput input) throws IOException {
        this.dir = dir;
        this.name = input.readString();
        this.docCount = input.readInt();
        if (format <= -2) {
            this.delGen = input.readLong();
            this.hasSingleNormFile = format <= -3 ? 1 == input.readByte() : false;
            int numNormGen = input.readInt();
            if (numNormGen == -1) {
                this.normGen = null;
            } else {
                this.normGen = new long[numNormGen];
                for (int j = 0; j < numNormGen; ++j) {
                    this.normGen[j] = input.readLong();
                }
            }
            this.isCompoundFile = input.readByte();
            this.preLockless = this.isCompoundFile == 0;
        } else {
            this.delGen = 0L;
            this.normGen = null;
            this.isCompoundFile = 0;
            this.preLockless = true;
            this.hasSingleNormFile = false;
        }
    }

    void setNumFields(int numFields) {
        if (this.normGen == null) {
            this.normGen = new long[numFields];
            if (!this.preLockless) {
                for (int i = 0; i < numFields; ++i) {
                    this.normGen[i] = -1L;
                }
            }
        }
    }

    boolean hasDeletions() throws IOException {
        if (this.delGen == -1L) {
            return false;
        }
        if (this.delGen >= 1L) {
            return true;
        }
        return this.dir.fileExists(this.getDelFileName());
    }

    void advanceDelGen() {
        this.delGen = this.delGen == -1L ? 1L : ++this.delGen;
        this.files = null;
    }

    void clearDelGen() {
        this.delGen = -1L;
        this.files = null;
    }

    public Object clone() {
        SegmentInfo si = new SegmentInfo(this.name, this.docCount, this.dir);
        si.isCompoundFile = this.isCompoundFile;
        si.delGen = this.delGen;
        si.preLockless = this.preLockless;
        si.hasSingleNormFile = this.hasSingleNormFile;
        if (this.normGen != null) {
            si.normGen = (long[])this.normGen.clone();
        }
        return si;
    }

    String getDelFileName() {
        if (this.delGen == -1L) {
            return null;
        }
        return IndexFileNames.fileNameFromGeneration(this.name, ".del", this.delGen);
    }

    boolean hasSeparateNorms(int fieldNumber) throws IOException {
        if (this.normGen == null && this.preLockless || this.normGen != null && this.normGen[fieldNumber] == 0L) {
            String fileName = this.name + ".s" + fieldNumber;
            return this.dir.fileExists(fileName);
        }
        return this.normGen != null && this.normGen[fieldNumber] != -1L;
    }

    boolean hasSeparateNorms() throws IOException {
        int i;
        if (this.normGen == null) {
            if (!this.preLockless) {
                return false;
            }
            String[] result = this.dir.list();
            if (result == null) {
                throw new IOException("cannot read directory " + this.dir + ": list() returned null");
            }
            String pattern = this.name + ".s";
            int patternLength = pattern.length();
            for (int i2 = 0; i2 < result.length; ++i2) {
                if (!result[i2].startsWith(pattern) || !Character.isDigit(result[i2].charAt(patternLength))) continue;
                return true;
            }
            return false;
        }
        for (i = 0; i < this.normGen.length; ++i) {
            if (this.normGen[i] < 1L) continue;
            return true;
        }
        for (i = 0; i < this.normGen.length; ++i) {
            if (this.normGen[i] != 0L || !this.hasSeparateNorms(i)) continue;
            return true;
        }
        return false;
    }

    void advanceNormGen(int fieldIndex) {
        if (this.normGen[fieldIndex] == -1L) {
            this.normGen[fieldIndex] = 1L;
        } else {
            int n = fieldIndex;
            this.normGen[n] = this.normGen[n] + 1L;
        }
        this.files = null;
    }

    String getNormFileName(int number) throws IOException {
        long gen = this.normGen == null ? 0L : this.normGen[number];
        if (this.hasSeparateNorms(number)) {
            String prefix = ".s";
            return IndexFileNames.fileNameFromGeneration(this.name, prefix + number, gen);
        }
        if (this.hasSingleNormFile) {
            String prefix = ".nrm";
            return IndexFileNames.fileNameFromGeneration(this.name, prefix, 0L);
        }
        String prefix = ".f";
        return IndexFileNames.fileNameFromGeneration(this.name, prefix + number, 0L);
    }

    void setUseCompoundFile(boolean isCompoundFile) {
        this.isCompoundFile = isCompoundFile ? (byte)1 : (byte)-1;
        this.files = null;
    }

    boolean getUseCompoundFile() throws IOException {
        if (this.isCompoundFile == -1) {
            return false;
        }
        if (this.isCompoundFile == 1) {
            return true;
        }
        return this.dir.fileExists(this.name + "." + "cfs");
    }

    void write(IndexOutput output) throws IOException {
        output.writeString(this.name);
        output.writeInt(this.docCount);
        output.writeLong(this.delGen);
        output.writeByte((byte)(this.hasSingleNormFile ? 1 : 0));
        if (this.normGen == null) {
            output.writeInt(-1);
        } else {
            output.writeInt(this.normGen.length);
            for (int j = 0; j < this.normGen.length; ++j) {
                output.writeLong(this.normGen[j]);
            }
        }
        output.writeByte(this.isCompoundFile);
    }

    public List files() throws IOException {
        block14: {
            boolean useCompoundFile;
            block13: {
                if (this.files != null) {
                    return this.files;
                }
                this.files = new ArrayList();
                useCompoundFile = this.getUseCompoundFile();
                if (useCompoundFile) {
                    this.files.add(this.name + "." + "cfs");
                } else {
                    for (int i = 0; i < IndexFileNames.INDEX_EXTENSIONS_IN_COMPOUND_FILE.length; ++i) {
                        String ext = IndexFileNames.INDEX_EXTENSIONS_IN_COMPOUND_FILE[i];
                        String fileName = this.name + "." + ext;
                        if (!this.dir.fileExists(fileName)) continue;
                        this.files.add(fileName);
                    }
                }
                String delFileName = IndexFileNames.fileNameFromGeneration(this.name, ".del", this.delGen);
                if (delFileName != null && (this.delGen >= 1L || this.dir.fileExists(delFileName))) {
                    this.files.add(delFileName);
                }
                if (this.normGen == null) break block13;
                for (int i = 0; i < this.normGen.length; ++i) {
                    String fileName;
                    long gen = this.normGen[i];
                    if (gen >= 1L) {
                        this.files.add(IndexFileNames.fileNameFromGeneration(this.name, ".s" + i, gen));
                        continue;
                    }
                    if (-1L == gen) {
                        if (this.hasSingleNormFile || useCompoundFile || !this.dir.fileExists(fileName = this.name + "." + "f" + i)) continue;
                        this.files.add(fileName);
                        continue;
                    }
                    if (0L != gen) continue;
                    fileName = null;
                    if (useCompoundFile) {
                        fileName = this.name + "." + "s" + i;
                    } else if (!this.hasSingleNormFile) {
                        fileName = this.name + "." + "f" + i;
                    }
                    if (fileName == null || !this.dir.fileExists(fileName)) continue;
                    this.files.add(fileName);
                }
                break block14;
            }
            if (!this.preLockless && (this.hasSingleNormFile || useCompoundFile)) break block14;
            String prefix = useCompoundFile ? this.name + "." + "s" : this.name + "." + "f";
            int prefixLength = prefix.length();
            String[] allFiles = this.dir.list();
            if (allFiles == null) {
                throw new IOException("cannot read directory " + this.dir + ": list() returned null");
            }
            for (int i = 0; i < allFiles.length; ++i) {
                String fileName = allFiles[i];
                if (fileName.length() <= prefixLength || !Character.isDigit(fileName.charAt(prefixLength)) || !fileName.startsWith(prefix)) continue;
                this.files.add(fileName);
            }
        }
        return this.files;
    }
}

