/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler;

import fr.gouv.culture.sdx.utils.Utilities;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class SimpleTimeScheduler implements TimeScheduler {

    protected Hashtable triggers = new Hashtable();
    protected Hashtable targets = new Hashtable();


    public void addTrigger(String name, TimeTrigger trigger, Target target) {
        if (Utilities.checkString(name) && trigger != null && target != null) {
            this.triggers.put(name, trigger);
            this.targets.put(name, target);
        }
    }

    public void removeTrigger(String name)
            throws NoSuchElementException {
        if (Utilities.checkString(name)) {
            this.triggers.remove(name);
            this.targets.remove(name);
        }
    }

    public void resetTrigger(String name)
            throws NoSuchElementException {
        if (Utilities.checkString(name)) {
            TimeTrigger trigger = (TimeTrigger) this.triggers.get(name);
            if (trigger != null)
                trigger.reset();
        }
    }


    public void start() {
        Enumeration trigKeys = this.triggers.keys();
        if (trigKeys != null) {
            while (trigKeys.hasMoreElements()) {
                String trigName = (String) trigKeys.nextElement();
                launchScheduleThread(trigName);

            }
        }

    }

    protected synchronized void launchScheduleThread(final String triggerName) {
        if (triggerName != null) {
            final TimeTrigger trigger = (TimeTrigger) this.triggers.get(triggerName);
            final Target target = (Target) this.targets.get(triggerName);
            if (trigger != null && target != null) {
                long now = System.currentTimeMillis();
                long next = trigger.getTimeAfter(now);
                final long timeUntilTrigger = next - now;

                new Thread() {
                    public void run() {
                        synchronized (this) {
                            try {
                                wait(timeUntilTrigger);
                                // wait for trigger time or signal
                                target.targetTriggered(triggerName);
                                launchScheduleThread(triggerName);

                            } catch (InterruptedException ignore) {
                            }
                        }

                    }
                }.start();

            }
        }
    }


}
