/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.thesaurus;

import fr.gouv.culture.sdx.exception.SDXException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.excalibur.xml.sax.XMLizable;

/**
 * A thesaurus managed by SDX.
 *
 */
public interface Thesaurus extends XMLizable, Configurable {

    static final String NAMESPACE_URI = "http://sdx.culture.fr/thesaurus/1.0";
    static final String NAMESPACE_PREFIX = "thes";
    /** A "BROADER TERM" relation. */
    static final int RELATION_BROADER_TERM = 0;
    /** A "BROADER TERMS" relation. */
    static final int RELATION_BROADER_TERMS = 1;
    /** A "NARROWER TERM" relation. */
    static final int RELATION_NARROWER_TERM = 2;
    /** A "RELATED TERM" relation. */
    static final int RELATION_RELATED_TERM = 3;
    /** A "USE" relation. */
    static final int RELATION_USE = 4;
    /** A "USED FOR" relation. */
    static final int RELATION_USED_FOR = 5;
    /** A "SCOPE NOTE" relation. */
    static final int RELATION_SCOPE_NOTE = 6;
    /** An "EQUIVALENT TERM" relation*/
    static final int RELATION_EQUIVALENT_TERM = 7;
    /** A generic relation for Partial Equivalence TODO:maybe need more specific relations here*/
    static final int RELATION_PARTIAL_EQIUVALENCE = 8;

    public void compile() throws SDXException;

    /**Returns an abbreviation String for a relation type defined in the thesaurus*/
    String getRelationTypeAbbreviation(int type);

    /**Returns an int for a relation type String defined in the thesaurus*/
    int getRelationTypeInt(String abbr);



}
