/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
/*
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: 5 nov. 2002
 * Time: 11:39:14
 * To change template for new class use
 * Code Style | Class Templates options (Tools | IDE Options).
 */
package fr.gouv.culture.sdx.search.lucene.analysis;

import java.io.Reader;

import org.apache.lucene.analysis.TokenStream;

import fr.gouv.culture.sdx.search.lucene.analysis.filter.ChineseFilter;
import fr.gouv.culture.sdx.search.lucene.analysis.tokenizer.ChineseTokenizer;

/**
 * Title: ChineseAnalyzer
 * Description:
 *   Subclass of org.apache.lucene.analysis.Analyzer
 *   build from a ChineseTokenizer, filtered with ChineseFilter.
 * Copyright:   Copyright (c) 2001
 * Company:
 * @author Yiyi Sun
 * @version 1.0
 * @deprecated use {@link org.apache.lucene.analysis.cn.ChineseAnalyzer} instead
 */
public class Analyzer_cn extends DefaultAnalyzer {

	/**
	 * @see fr.gouv.culture.sdx.search.lucene.analysis.AbstractAnalyzer#getAnalyserType()
	 */
	protected String getAnalyzerType() {
		return Analyzer_cn.ANALYZER_TYPE;
	}
	protected final static String ANALYZER_TYPE="Analyzer_cn";
	
    /**
     * Creates a TokenStream which tokenizes all the text in the provided Reader.
     *
     * @return  A TokenStream build from a ChineseTokenizer filtered with ChineseFilter.
     */
    public final TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = new ChineseTokenizer(reader);
        if (stopTable != null)
            result = new ChineseFilter(result, stopTable);
        else
            result = new ChineseFilter(result);

        return result;
    }

}
