/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.documentbase;

import fr.gouv.culture.sdx.search.lucene.query.Index;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.database.Database;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public abstract class AbstractIDGenerator extends AbstractSdxObject implements IDGenerator {

    /** The attribute used to generate a prefix for an id generator. */
    protected final String ATTRIBUTE_ID_PREFIX = "idPrefix";
    /** The attribute used to generate a suffix for an id generator. */
    protected final String ATTRIBUTE_ID_SUFFIX = "idSuffix";

    protected Database _database = null;
    /** Prefix for generated ids. */
    protected String idPrefix = "";
    /** Suffix for generated ids. */
    protected String idSuffix = "";

    public void configure(Configuration configuration) throws ConfigurationException {
        if (configuration != null) {
            this.idPrefix = configuration.getAttribute(ATTRIBUTE_ID_PREFIX, "");
            this.idSuffix = configuration.getAttribute(ATTRIBUTE_ID_SUFFIX, "");
        }

    }

    public String getSuffix() {
        return idSuffix;
    }

    public void setSuffix(String idSuffix) {
        this.idSuffix = idSuffix;
    }

    public String getPrefix() {
        return idPrefix;
    }

    public void setPrefix(String idPrefix) {
        this.idPrefix = idPrefix;
    }

    /**Was used to provide and index for id uniqueness verification
     *
     * @deprecated No longer useful
     */
    public void setIndex(Index docBaseIndex) {
    }

    public void setDatabase(Database database) {
        this._database = database;
    }

    /**If no lucene index has been provided
     * (i.e. it is <code>null</code>) this method
     * will return true as it has no concrete context
     * by which it can determine uniqueness
     *
     * @param id    The id to verify
     * @return
     */
    public boolean isIdUnique(String id) {

        if (!Utilities.checkString(id)) return false;
        if (this._database == null) return true;//no database set, all id's are technically unique as we have no context
        return !this._database.entityExists(id);
    }

    public void setIdFieldName(String fieldName) {
    }

    public String generate() {
        return generate(this.idPrefix, this.idSuffix);
    }

    protected String getClassNameSuffix() {
        return IDGenerator.CLASS_NAME_SUFFIX;
    }

    /* (non-Javadoc)
	 * @see fr.gouv.culture.sdx.utils.AbstractSdxObject#initToSax()
	 */
	protected boolean initToSax() {
		return true;
	}

	/**Init the LinkedHashMap _xmlizable_volatile_objects with the objects in order to describ them in XML
	 * Some objects need to be refresh each time a toSAX is called*/
	protected void initVolatileObjectsToSax() {}
}
