/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.components.source.SourceInspector;
import org.apache.cocoon.components.source.helpers.SourceProperty;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;

public abstract class AbstractImageSourceInspector
extends AbstractLogEnabled
implements SourceInspector {
    public static final String PROPERTY_NS = "http://apache.org/cocoon/inspector/image/1.0";
    public static final String IMAGE_WIDTH_PROPERTY_NAME = "width";
    public static final String IMAGE_HEIGHT_PROPERTY_NAME = "height";
    private static final SourceValidity VALIDITY = new NOPValidity();
    private static final String[] HANDLED_PROPERTIES = new String[]{"http://apache.org/cocoon/inspector/image/1.0#height", "http://apache.org/cocoon/inspector/image/1.0#width"};

    public final SourceProperty getSourceProperty(Source source, String namespace, String name) throws SourceException {
        if (this.handlesProperty(namespace, name) && this.isImageMimeType(source) && this.isImageFileType(source)) {
            if (name.equals(IMAGE_WIDTH_PROPERTY_NAME)) {
                return new SourceProperty(PROPERTY_NS, IMAGE_WIDTH_PROPERTY_NAME, String.valueOf(this.getImageSize(source)[0]));
            }
            if (name.equals(IMAGE_HEIGHT_PROPERTY_NAME)) {
                return new SourceProperty(PROPERTY_NS, IMAGE_HEIGHT_PROPERTY_NAME, String.valueOf(this.getImageSize(source)[1]));
            }
        }
        return null;
    }

    public final SourceProperty[] getSourceProperties(Source source) throws SourceException {
        if (this.isImageMimeType(source) && this.isImageFileType(source)) {
            int[] size = this.getImageSize(source);
            return new SourceProperty[]{new SourceProperty(PROPERTY_NS, IMAGE_WIDTH_PROPERTY_NAME, String.valueOf(size[0])), new SourceProperty(PROPERTY_NS, IMAGE_HEIGHT_PROPERTY_NAME, String.valueOf(size[1]))};
        }
        return null;
    }

    public final String[] getHandledPropertyTypes() {
        return HANDLED_PROPERTIES;
    }

    public final boolean handlesProperty(String namespace, String name) {
        return namespace.equals(PROPERTY_NS) && (name.equals(IMAGE_WIDTH_PROPERTY_NAME) || name.equals(IMAGE_HEIGHT_PROPERTY_NAME));
    }

    public SourceValidity getValidity(Source source) {
        return VALIDITY;
    }

    protected abstract boolean isImageMimeType(Source var1);

    protected abstract boolean isImageFileType(Source var1) throws SourceException;

    protected abstract int[] getImageSize(Source var1) throws SourceException;
}

