/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.repository.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Properties;
import org.apache.avalon.excalibur.io.IOUtil;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.components.repository.Repository;
import org.apache.cocoon.components.repository.helpers.CredentialsToken;
import org.apache.cocoon.components.repository.helpers.RepositoryPropertyHelper;
import org.apache.cocoon.components.repository.helpers.RepositoryTransactionHelper;
import org.apache.cocoon.components.repository.helpers.RepositoryVersioningHelper;
import org.apache.cocoon.components.repository.impl.WebDAVRepositoryPropertyHelper;
import org.apache.cocoon.components.repository.impl.WebDAVRepositoryTransactionHelper;
import org.apache.cocoon.components.repository.impl.WebDAVRepositoryVersioningHelper;
import org.apache.cocoon.components.webdav.WebDAVUtil;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.httpclient.HttpException;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.xml.dom.DOMParser;
import org.apache.webdav.lib.WebdavResource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebDAVRepository
extends AbstractLogEnabled
implements Repository,
Serviceable,
Configurable,
Initializable,
Disposable,
Component {
    public static final String REPO_BASE_CONF = "repo-base";
    private ServiceManager manager;
    private WebDAVRepositoryPropertyHelper propertyHelper;
    private WebDAVRepositoryTransactionHelper transactionHelper;
    private WebDAVRepositoryVersioningHelper versioningHelper;
    private String repoBaseUrl;
    private CredentialsToken credentials;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.repoBaseUrl = configuration.getChild(REPO_BASE_CONF).getValue();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("configuring repository location " + this.repoBaseUrl);
        }
    }

    public void initialize() throws Exception {
        this.propertyHelper = new WebDAVRepositoryPropertyHelper(this.credentials, this);
        this.transactionHelper = new WebDAVRepositoryTransactionHelper(this.credentials, this);
        this.versioningHelper = new WebDAVRepositoryVersioningHelper(this.credentials, this);
        LifecycleHelper lh = new LifecycleHelper(this.getLogger(), null, this.manager, null, null);
        lh.setupComponent((Object)this.propertyHelper, true);
        lh.setupComponent((Object)this.transactionHelper, true);
        lh.setupComponent((Object)this.versioningHelper, true);
    }

    public void dispose() {
        this.manager = null;
        this.propertyHelper.dispose();
        this.transactionHelper.dispose();
        this.versioningHelper.dispose();
        this.propertyHelper = null;
        this.transactionHelper = null;
        this.versioningHelper = null;
    }

    public String getContentString(String uri) throws ProcessingException {
        try {
            return IOUtil.toString((InputStream)this.getContentStream(uri));
        }
        catch (IOException ioe) {
            throw new ProcessingException("Error loading resource: " + this.repoBaseUrl + uri, (Throwable)ioe);
        }
    }

    public InputStream getContentStream(String uri) throws ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("getting content of: " + uri);
        }
        try {
            WebdavResource resource = WebDAVUtil.getWebdavResource(this.getAbsoluteURI(uri));
            if (!resource.exists()) {
                throw new HttpException(uri + " does not exist");
            }
            return new BufferedInputStream(resource.getMethodData());
        }
        catch (MalformedURLException mue) {
            throw new ProcessingException("Bad URL for resource: " + this.repoBaseUrl + uri, (Throwable)mue);
        }
        catch (IOException ioe) {
            throw new ProcessingException("Error loading resource: " + this.repoBaseUrl + uri, (Throwable)ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document getContentDOM(String uri) throws ProcessingException {
        Document document;
        DOMParser parser = null;
        try {
            try {
                parser = (DOMParser)this.manager.lookup(DOMParser.ROLE);
                document = parser.parseDocument(new InputSource(this.getContentStream(uri)));
                Object var7_5 = null;
            }
            catch (SAXException se) {
                throw new ProcessingException("Error parsing: " + this.repoBaseUrl + uri, (Throwable)se);
            }
            catch (IOException ioe) {
                throw new ProcessingException("Error getting: " + this.repoBaseUrl + uri, (Throwable)ioe);
            }
            catch (ServiceException se) {
                throw new ProcessingException("Error getting DOMParser", (Throwable)se);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.manager.release((Object)parser);
            throw throwable;
        }
        this.manager.release((Object)parser);
        return document;
    }

    public boolean saveContent(String uri, String content) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("save content to " + uri);
        }
        try {
            return WebDAVUtil.getWebdavResource(this.getAbsoluteURI(uri)).putMethod(content);
        }
        catch (HttpException he) {
            this.getLogger().error("Error saving: " + this.repoBaseUrl + uri, (Throwable)he);
        }
        catch (IOException ioe) {
            this.getLogger().error("Error saving: " + this.repoBaseUrl + uri, (Throwable)ioe);
        }
        return false;
    }

    public boolean saveContent(String uri, Node node) {
        try {
            Properties format = new Properties();
            format.put("method", "xml");
            format.put("omit-xml-declaration", "yes");
            return this.saveContent(uri, XMLUtils.serializeNode((Node)node, (Properties)format));
        }
        catch (ProcessingException pe) {
            this.getLogger().error("Error saving dom to: " + this.repoBaseUrl + uri, (Throwable)pe);
            return false;
        }
    }

    public boolean saveContent(String uri, Source source) {
        try {
            return this.saveContent(uri, IOUtil.toString((InputStream)source.getInputStream()));
        }
        catch (IOException ioe) {
            this.getLogger().error("Error saving source: " + source.getURI() + " to " + this.repoBaseUrl + uri, (Throwable)ioe);
            return false;
        }
    }

    public boolean createResource(String uri, String content) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("creating new resource " + uri);
        }
        try {
            WebDAVUtil.createResource(this.getAbsoluteURI(uri), content);
            return true;
        }
        catch (HttpException he) {
            this.getLogger().error("Error creating resource: " + this.repoBaseUrl + uri, (Throwable)he);
        }
        catch (IOException ioe) {
            this.getLogger().error("Error creating resource: " + this.repoBaseUrl + uri, (Throwable)ioe);
        }
        return false;
    }

    public boolean exists(String uri) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("checking existance of " + uri);
        }
        try {
            return WebDAVUtil.getWebdavResource(this.getAbsoluteURI(uri)).exists();
        }
        catch (HttpException he) {
            this.getLogger().error("HTTP Error occurred while checking for existance of: " + uri, (Throwable)he);
        }
        catch (IOException ioe) {
            this.getLogger().error("IO Error occurred while checking for existance of: " + uri, (Throwable)ioe);
        }
        return false;
    }

    public boolean copy(String uri, String dest, boolean recurse, boolean overwrite) {
        try {
            WebDAVUtil.copyResource(this.getAbsoluteURI(uri), this.getAbsoluteURI(dest), recurse, overwrite);
            return true;
        }
        catch (HttpException he) {
            this.getLogger().error("HTTP Error copying: " + this.repoBaseUrl + uri, (Throwable)he);
        }
        catch (IOException ioe) {
            this.getLogger().error("IO Error copying: " + this.repoBaseUrl + uri, (Throwable)ioe);
        }
        return false;
    }

    public boolean move(String uri, String dest, boolean recurse, boolean overwrite) {
        try {
            WebDAVUtil.moveResource(this.getAbsoluteURI(uri), this.getAbsoluteURI(dest), recurse, overwrite);
            return true;
        }
        catch (HttpException he) {
            this.getLogger().error("HTTP Error moving: " + this.repoBaseUrl + uri, (Throwable)he);
        }
        catch (IOException ioe) {
            this.getLogger().error("IO Error moving: " + this.repoBaseUrl + uri, (Throwable)ioe);
        }
        return false;
    }

    public boolean remove(String uri) {
        try {
            return WebDAVUtil.getWebdavResource(this.getAbsoluteURI(uri)).deleteMethod();
        }
        catch (HttpException he) {
            this.getLogger().error("HTTP Error removing: " + this.repoBaseUrl + uri, (Throwable)he);
        }
        catch (IOException ioe) {
            this.getLogger().error("IO Error removing: " + this.repoBaseUrl + uri, (Throwable)ioe);
        }
        return false;
    }

    public boolean makeCollection(String uri, boolean recursive) {
        try {
            if (uri.endsWith("/")) {
                uri = uri.substring(0, uri.length() - 1);
            }
            if (recursive) {
                WebDAVUtil.makePath(this.getAbsoluteURI(uri));
                return true;
            }
            String parent = uri.substring(0, uri.lastIndexOf("/"));
            String collection = uri.substring(uri.lastIndexOf("/") + 1);
            WebDAVUtil.makeCollection(this.getAbsoluteURI(parent), collection);
            return true;
        }
        catch (HttpException he) {
            this.getLogger().error("HTTP Error making collection: " + this.repoBaseUrl + uri, (Throwable)he);
        }
        catch (IOException ioe) {
            this.getLogger().error("IO Error making collection: " + this.repoBaseUrl + uri, (Throwable)ioe);
        }
        return false;
    }

    public RepositoryPropertyHelper getPropertyHelper() {
        return this.propertyHelper;
    }

    public RepositoryTransactionHelper getTransactionHelper() {
        return this.transactionHelper;
    }

    public RepositoryVersioningHelper getVersioningHelper() {
        return this.versioningHelper;
    }

    public String getAbsoluteURI(String uri) {
        return "http://" + this.credentials.getPrincipal().getName() + ":" + this.credentials.getCredentials() + "@" + this.repoBaseUrl + uri;
    }

    public CredentialsToken getCredentials() {
        return this.credentials;
    }

    public void setCredentials(CredentialsToken credentials) {
        this.credentials = credentials;
    }
}

