/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.mail.transformation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.mail.datasource.SourceDataSource;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.excalibur.source.Source;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SendMailTransformer
extends AbstractSAXTransformer {
    public static final String NAMESPACE = "http://apache.org/cocoon/transformation/sendmail";
    public static final String ELEMENT_SENDMAIL = "sendmail";
    public static final String ELEMENT_SMTPHOST = "smtphost";
    public static final String ELEMENT_SMTPPORT = "smtpport";
    public static final String ELEMENT_MAILFROM = "from";
    public static final String ELEMENT_MAILTO = "to";
    public static final String ELEMENT_REPLYTO = "reply-to";
    public static final String ELEMENT_MAILSUBJECT = "subject";
    public static final String ELEMENT_MAILBODY = "body";
    public static final String ELEMENT_ATTACHMENT = "attachment";
    public static final String ELEMENT_ATTACHMENT_CONTENT = "content";
    public static final String ELEMENT_EMAIL_PREFIX = "email";
    public static final String ELEMENT_ERROR = "error";
    public static final String ELEMENT_SUCCESS = "success";
    public static final String ELEMENT_FAILURE = "failure";
    public static final String ELEMENT_RESULT = "result";
    public static final String DEFAULT_BODY_MIMETYPE = "text/html";
    protected static final int MODE_NONE = 0;
    protected static final int MODE_SMTPHOST = 1;
    protected static final int MODE_FROM = 2;
    protected static final int MODE_TO = 3;
    protected static final int MODE_SUBJECT = 4;
    protected static final int MODE_BODY = 5;
    protected static final int MODE_ATTACHMENT = 6;
    protected static final int MODE_ATTACHMENT_CONTENT = 7;
    protected static final int MODE_REPLY_TO = 8;
    protected static final int MODE_SMTPPORT = 9;
    public static final String PARAM_SMTPHOST = "smtphost";
    public static final String PARAM_SMTPPORT = "smtpport";
    public static final String PARAM_FROM = "from";
    public static final String PARAM_TO = "to";
    public static final String PARAM_REPLY_TO = "reply-to";
    public static final String PARAM_SUBJECT = "subject";
    public static final String PARAM_BODY = "body";
    public static final String PARAM_SENDPARTIAL = "sendpartial";
    protected int mode;
    protected List toAddresses;
    protected List replyToAddresses;
    protected List defaultToAddresses;
    protected List defaultReplyToAddresses;
    protected List attachments;
    protected String subject;
    protected String body;
    protected String bodyURI;
    protected String bodyMimeType;
    protected String mailHost;
    protected int mailPort;
    protected String fromAddress;
    protected AttachmentDescriptor attachmentDescriptor;
    protected int port;
    protected String contextPath;
    protected boolean sendPartial;
    protected Message smtpMessage;
    protected String defaultSmtpHost;
    protected int defaultSmtpPort;
    protected String defaultFromAddress;
    protected List usedSources = new ArrayList();

    public SendMailTransformer() {
        this.defaultNamespaceURI = NAMESPACE;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.defaultSmtpHost = configuration.getChild("smtphost").getValue("");
        this.defaultSmtpPort = configuration.getChild("smtpport").getValueAsInteger(25);
        this.defaultFromAddress = configuration.getChild("from").getValue("");
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.mailHost = par.getParameter("smtphost", this.defaultSmtpHost);
        this.mailPort = par.getParameterAsInteger("smtpport", this.defaultSmtpPort);
        this.fromAddress = par.getParameter("from", this.defaultFromAddress);
        this.port = this.request.getServerPort();
        this.contextPath = this.request.getContextPath();
        this.sendPartial = par.getParameterAsBoolean(PARAM_SENDPARTIAL, true);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Using host " + this.mailHost + " on port " + this.mailPort + ", from address " + this.fromAddress);
        }
        this.attachments = new ArrayList();
        this.defaultToAddresses = new ArrayList();
        SendMailTransformer.appendToAddress(this.defaultToAddresses, par.getParameter("to", ""));
        this.defaultReplyToAddresses = new ArrayList();
        SendMailTransformer.appendToAddress(this.defaultReplyToAddresses, par.getParameter("reply-to", ""));
        this.subject = par.getParameter("subject", null);
        this.body = par.getParameter("body", null);
    }

    public void startTransformingElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (name.equals(ELEMENT_SENDMAIL)) {
            this.toAddresses = new ArrayList(this.defaultToAddresses);
            this.replyToAddresses = new ArrayList(this.defaultReplyToAddresses);
            this.attachments.clear();
        } else if (name.equals("smtphost")) {
            this.startTextRecording();
            this.mode = 1;
        } else if (name.equals("smtpport")) {
            this.startTextRecording();
            this.mode = 9;
        } else if (name.equals("from")) {
            this.startTextRecording();
            this.mode = 2;
        } else if (name.equals("to")) {
            this.startTextRecording();
            this.mode = 3;
        } else if (name.equals("reply-to")) {
            this.startTextRecording();
            this.mode = 8;
        } else if (name.equals("subject")) {
            this.startTextRecording();
            this.mode = 4;
        } else if (name.equals("body")) {
            String mType;
            String strBody = attr.getValue("src");
            if (strBody != null) {
                this.bodyURI = strBody;
            }
            this.bodyMimeType = (mType = attr.getValue("mime-type")) != null ? mType : DEFAULT_BODY_MIMETYPE;
            this.startTextRecording();
            this.mode = 5;
        } else if (name.equals(ELEMENT_ATTACHMENT)) {
            this.attachmentDescriptor = new AttachmentDescriptor(attr.getValue("name"), attr.getValue("mime-type"), attr.getValue("src"), attr.getValue("url"));
            this.mode = 6;
        } else if (name.equals(ELEMENT_ATTACHMENT_CONTENT)) {
            this.startSerializedXMLRecording(new Properties());
            this.mode = 7;
        } else {
            throw new SAXException("Unknown element <" + name + ">");
        }
    }

    public void endTransformingElement(String uri, String name, String raw) throws SAXException, ProcessingException {
        if (name.equals(ELEMENT_SENDMAIL)) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Mail Subject: " + this.subject + "\n" + "Body: " + this.body);
            }
            this.sendMail();
        } else if (name.equals("smtphost")) {
            this.mailHost = this.endTextRecording();
            this.mode = 0;
        } else if (name.equals("smtpport")) {
            this.mailPort = Integer.parseInt(this.endTextRecording());
            this.mode = 0;
        } else if (name.equals("from")) {
            this.fromAddress = this.endTextRecording();
            this.mode = 0;
        } else if (name.equals("to")) {
            this.toAddresses.add(this.endTextRecording());
            this.mode = 0;
        } else if (name.equals("reply-to")) {
            this.replyToAddresses.add(this.endTextRecording());
            this.mode = 0;
        } else if (name.equals("subject")) {
            String strSubject = this.endTextRecording();
            if (strSubject != null) {
                this.subject = strSubject;
            } else {
                this.getLogger().debug("Mail: No Subject");
            }
            this.mode = 0;
        } else if (name.equals(ELEMENT_ATTACHMENT)) {
            this.attachments.add(this.attachmentDescriptor.copy());
            this.attachmentDescriptor = null;
            this.mode = 0;
        } else if (name.equals(ELEMENT_ATTACHMENT_CONTENT)) {
            this.attachmentDescriptor.setContent(this.endSerializedXMLRecording());
            this.mode = 0;
        } else if (name.equals("body")) {
            String strB;
            block26: {
                strB = null;
                try {
                    strB = this.endTextRecording();
                }
                catch (Exception e) {
                    if (!this.getLogger().isDebugEnabled()) break block26;
                    this.getLogger().debug("Mail: No Body as String in config-file available");
                }
            }
            if (strB != null) {
                this.body = strB;
            }
            this.mode = 0;
        } else {
            throw new SAXException("Unknown element <" + name + ">");
        }
    }

    private static void appendToAddress(List addresses, String s) {
        StringTokenizer t = new StringTokenizer(s.trim(), ";");
        while (t.hasMoreElements()) {
            addresses.add(t.nextToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMail() throws SAXException {
        try {
            ++this.ignoreHooksCount;
            super.sendStartElementEventNS(ELEMENT_RESULT);
            Properties props = new Properties();
            props.put("mail.smtp.host", this.mailHost);
            props.put("mail.smtp.port", String.valueOf(this.mailPort));
            if (this.subject == null) {
                ++this.ignoreHooksCount;
                super.sendStartElementEventNS(ELEMENT_ERROR);
                super.sendTextEvent("Subject not available - sending mail aborted");
                super.sendEndElementEventNS(ELEMENT_ERROR);
                --this.ignoreHooksCount;
                return;
            }
            if (this.body == null && this.bodyURI == null) {
                ++this.ignoreHooksCount;
                super.sendStartElementEventNS(ELEMENT_ERROR);
                super.sendTextEvent("Mailbody not available - sending mail aborted");
                super.sendEndElementEventNS(ELEMENT_ERROR);
                --this.ignoreHooksCount;
                return;
            }
            Session session = Session.getDefaultInstance((Properties)props, null);
            Transport trans = session.getTransport("smtp");
            trans.connect();
            this.smtpMessage = this.setUpMessage(session);
            if (this.sendPartial) {
                for (int i = 0; i < this.toAddresses.size(); ++i) {
                    ArrayList v = new ArrayList(1);
                    v.add(this.toAddresses.get(i));
                    this.sendMail(v, trans);
                }
            } else {
                this.sendMail(this.toAddresses, trans);
            }
            trans.close();
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            this.getLogger().error("Exception sending mail", (Throwable)e);
            this.sendExceptionElement(e);
        }
        finally {
            super.sendEndElementEventNS(ELEMENT_RESULT);
            --this.ignoreHooksCount;
        }
    }

    private void sendMail(List newAddresses, Transport trans) throws Exception {
        AddressHandler[] iA = new AddressHandler[newAddresses.size()];
        try {
            for (int i = 0; i < newAddresses.size(); ++i) {
                InternetAddress inA = new InternetAddress((String)newAddresses.get(i));
                iA[i] = new AddressHandler(inA);
            }
            InternetAddress[] iaArr = SendMailTransformer.getAddresses(iA);
            this.smtpMessage.setRecipients(Message.RecipientType.TO, (Address[])iaArr);
            trans.sendMessage(this.smtpMessage, (Address[])iaArr);
        }
        catch (SendFailedException e) {
            this.getLogger().error("Exception during sending of mail", (Throwable)e);
            Address[] adr = e.getInvalidAddresses();
            for (int isfEx = 0; isfEx < iA.length; ++isfEx) {
                String tmpAddress = iA[isfEx].getAddress().getAddress();
                for (int sei = 0; sei < adr.length; ++sei) {
                    if (!((InternetAddress)adr[sei]).getAddress().equalsIgnoreCase(tmpAddress)) continue;
                    iA[isfEx].setSendMailResult("Invalid address");
                }
            }
            Address[] ad = e.getValidUnsentAddresses();
            for (int isfEx = 0; isfEx < iA.length; ++isfEx) {
                String tmpAddress = iA[isfEx].getAddress().getAddress();
                for (int sei = 0; sei < ad.length; ++sei) {
                    if (!((InternetAddress)ad[sei]).getAddress().equalsIgnoreCase(tmpAddress)) continue;
                    iA[isfEx].setSendMailResult("Recipient not found");
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error("Exception sending mail", (Throwable)e);
            this.sendExceptionElement(e);
            return;
        }
        this.generateSAXReportStatements(iA);
    }

    private Message setUpMessage(Session session) throws Exception {
        MimeMessage sm = new MimeMessage(session);
        Address[] replyTo = new Address[this.replyToAddresses.size()];
        for (int i = 0; i < this.replyToAddresses.size(); ++i) {
            replyTo[i] = new InternetAddress((String)this.replyToAddresses.get(i));
        }
        sm.setReplyTo(replyTo);
        sm.setFrom((Address)new InternetAddress(this.fromAddress));
        sm.setSubject(this.subject);
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        if (this.bodyURI != null) {
            Source inSrc = this.resolver.resolveURI(this.bodyURI);
            this.usedSources.add(inSrc);
            InputStream inStr = inSrc.getInputStream();
            byte[] byteArr = new byte[inStr.available()];
            inStr.read(byteArr);
            String mailBody = new String(byteArr);
            messageBodyPart.setContent((Object)mailBody, this.bodyMimeType);
        } else {
            messageBodyPart.setContent((Object)this.body, this.bodyMimeType);
        }
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        Iterator i = this.attachments.iterator();
        while (i.hasNext()) {
            AttachmentDescriptor aD = (AttachmentDescriptor)i.next();
            messageBodyPart = new MimeBodyPart();
            if (!aD.isTextContent()) {
                Source inputSource = this.resolver.resolveURI(aD.isURLSource() ? aD.strAttrSrc : aD.strAttrFile);
                this.usedSources.add(inputSource);
                SourceDataSource dataSource = new SourceDataSource(inputSource, aD.strAttrMimeType, aD.strAttrName);
                dataSource.enableLogging(this.getLogger());
                messageBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
            } else {
                messageBodyPart.setContent((Object)aD.strContent, aD.strAttrMimeType);
            }
            messageBodyPart.setFileName(aD.strAttrName);
            multipart.addBodyPart((BodyPart)messageBodyPart);
        }
        sm.setContent((Multipart)multipart);
        sm.saveChanges();
        return sm;
    }

    private void generateSAXReportStatements(AddressHandler[] addressArr) throws SAXException {
        AttributesImpl impl = new AttributesImpl();
        for (int i = 0; i < addressArr.length; ++i) {
            String tmpAddress = addressArr[i].getAddress().getAddress();
            if (addressArr[i].getSendMailResult() == null) {
                impl.addAttribute("", "to", "to", "CDATA", tmpAddress);
                super.sendStartElementEventNS(ELEMENT_SUCCESS, (Attributes)impl);
                super.sendTextEvent("Mail sent");
                super.sendEndElementEventNS(ELEMENT_SUCCESS);
                continue;
            }
            impl.addAttribute("", "to", "to", "CDATA", tmpAddress);
            super.sendStartElementEventNS(ELEMENT_FAILURE, (Attributes)impl);
            super.sendTextEvent(addressArr[i].getSendMailResult());
            super.sendEndElementEventNS(ELEMENT_FAILURE);
        }
    }

    private void sendExceptionElement(Exception ex) {
        try {
            ++this.ignoreHooksCount;
            super.sendStartElementEventNS("exception");
            super.sendStartElementEventNS("message");
            super.sendTextEvent(ex.getMessage());
            super.sendEndElementEventNS("message");
            super.sendEndElementEventNS("exception");
            --this.ignoreHooksCount;
        }
        catch (SAXException e) {
            this.getLogger().error("Error while sending a SAX-Event", (Throwable)e);
        }
    }

    public static InternetAddress[] getAddresses(AddressHandler[] handlerArr) {
        InternetAddress[] iaArr = new InternetAddress[handlerArr.length];
        for (int i = 0; i < handlerArr.length; ++i) {
            iaArr[i] = handlerArr[i].getAddress();
        }
        return iaArr;
    }

    public void recycle() {
        this.toAddresses = null;
        this.defaultToAddresses = null;
        this.attachments = null;
        this.subject = null;
        this.body = null;
        this.bodyURI = null;
        this.mailHost = null;
        this.mailPort = 0;
        this.fromAddress = null;
        this.attachmentDescriptor = null;
        this.port = 0;
        this.contextPath = null;
        this.sendPartial = true;
        this.smtpMessage = null;
        Iterator i = this.usedSources.iterator();
        while (i.hasNext()) {
            Source source = (Source)i.next();
            this.resolver.release(source);
        }
        this.usedSources.clear();
        super.recycle();
    }

    static class AddressHandler {
        private InternetAddress address;
        private String sendMailResult;

        protected AddressHandler(InternetAddress newAddress) {
            this.address = newAddress;
        }

        protected void setSendMailResult(String newSendMailResult) {
            this.sendMailResult = newSendMailResult;
        }

        public InternetAddress getAddress() {
            return this.address;
        }

        public String getSendMailResult() {
            return this.sendMailResult;
        }
    }

    static class AttachmentDescriptor {
        String strAttrName;
        String strAttrMimeType;
        String strAttrSrc;
        String strAttrFile;
        String strContent;

        protected AttachmentDescriptor(String newAttrName, String newAttrMimeType, String newAttrSrc, String newAttrFile) {
            this.strAttrName = newAttrName;
            this.strAttrMimeType = newAttrMimeType;
            this.strAttrSrc = newAttrSrc;
            this.strAttrFile = newAttrFile;
        }

        protected void setContent(String newContent) {
            this.strContent = newContent;
        }

        protected AttachmentDescriptor copy() {
            AttachmentDescriptor aD = new AttachmentDescriptor(this.strAttrName, this.strAttrMimeType, this.strAttrSrc, this.strAttrFile);
            aD.setContent(this.strContent);
            return aD;
        }

        protected boolean isURLSource() {
            return this.strAttrSrc != null;
        }

        protected boolean isFileSource() {
            return this.strAttrFile != null;
        }

        protected boolean isTextContent() {
            return this.strContent != null;
        }
    }
}

