/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.mail;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.mail.MailCommandManager;
import org.apache.cocoon.mail.MailContext;
import org.apache.cocoon.mail.command.AbstractMailCommand;

public class MailCommandBuilder
extends AbstractLogEnabled {
    private Map cmdMap;

    public MailCommandBuilder() {
        this.configure();
    }

    public AbstractMailCommand buildAbstractMailCommand(MailContext mailContext) {
        AbstractMailCommand ama = null;
        try {
            Class clazz;
            String cmd = mailContext.getParameter("cmd");
            if (cmd == null) {
                cmd = (String)mailContext.get("mail-current-working-command");
            }
            if ((clazz = this.getClassForCommand(cmd)) != null) {
                ama = (AbstractMailCommand)clazz.newInstance();
                ama.enableLogging(this.getLogger());
                if (ama instanceof Contextualizable) {
                    ((Contextualizable)ama).contextualize((Context)mailContext);
                }
                return ama;
            }
            this.getLogger().error("Cmd " + String.valueOf(cmd) + " is invalid");
        }
        catch (Exception e) {
            String message = "Cannto build AbstractMailCommand";
            this.getLogger().error(message, (Throwable)e);
        }
        return ama;
    }

    protected Class getClassForCommand(String cmd) {
        return (Class)this.cmdMap.get(cmd);
    }

    public boolean isCommandMapped(String cmd) {
        return this.cmdMap.containsKey(cmd);
    }

    public void configure() {
        this.cmdMap = new HashMap();
        this.cmdMap.put("cat-folder", MailCommandManager.MailFolderCatCommand.class);
        this.cmdMap.put("refresh-folder", MailCommandManager.MailRefreshFolderCommand.class);
        this.cmdMap.put("list-folder", MailCommandManager.MailListFolderCommand.class);
        this.cmdMap.put("list-folder-messages", MailCommandManager.MailListMessagesCommand.class);
        this.cmdMap.put("search-folder-messages", MailCommandManager.MailSearchMessagesCommand.class);
        this.cmdMap.put("cat-message-by-uid", MailCommandManager.MailCatMessageByUIDCommand.class);
        this.cmdMap.put("cat-message-by-id", MailCommandManager.MailCatMessageByIdCommand.class);
        this.cmdMap.put("cat-attachment-of-message-by-id", MailCommandManager.MailCatAttachmentMessageByIdCommand.class);
    }
}

