/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource.cluster;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.excalibur.datasource.NoValidConnectionException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;

public abstract class AbstractDataSourceCluster
extends AbstractLogEnabled
implements Serviceable,
Configurable,
Initializable,
Disposable,
ThreadSafe {
    protected int m_size;
    private String[] m_dataSourceNames;
    private ServiceSelector m_dbSelector;
    private DataSourceComponent[] m_dataSources;

    public int getClusterSize() {
        return this.m_size;
    }

    public Connection getConnectionForIndex(int index) throws SQLException {
        if (index < 0 || index >= this.m_size) {
            throw new NoValidConnectionException("index (" + index + ") must be in the range 0 to " + (this.m_size - 1));
        }
        return this.m_dataSources[index].getConnection();
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.m_dbSelector = (ServiceSelector)manager.lookup(DataSourceComponent.ROLE + "Selector");
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        int i;
        this.m_size = configuration.getAttributeAsInteger("size");
        if (this.m_size < 1) {
            throw new ConfigurationException("Invalid value (" + this.m_size + ") for size attribute.");
        }
        this.m_dataSourceNames = new String[this.m_size];
        Configuration[] dataSourceConfigs = configuration.getChildren("dbpool");
        for (i = 0; i < dataSourceConfigs.length; ++i) {
            int index = dataSourceConfigs[i].getAttributeAsInteger("index");
            if (index < 0 || index >= this.m_size) {
                throw new ConfigurationException("The dbpool with index=\"" + index + "\" is invalid.  Index must be in the range 0 to " + (this.m_size - 1));
            }
            if (this.m_dataSourceNames[index] != null) {
                throw new ConfigurationException("Only one dbpool with index=\"" + index + "\" can be defined.");
            }
            this.m_dataSourceNames[index] = dataSourceConfigs[i].getValue();
        }
        for (i = 0; i < this.m_dataSourceNames.length; ++i) {
            if (this.m_dataSourceNames[i] != null) continue;
            throw new ConfigurationException("Expected a dbpool with index=\"" + i + "\"");
        }
    }

    public void initialize() throws Exception {
        this.m_dataSources = new DataSourceComponent[this.m_size];
        for (int i = 0; i < this.m_dataSourceNames.length; ++i) {
            this.m_dataSources[i] = (DataSourceComponent)this.m_dbSelector.select((Object)this.m_dataSourceNames[i]);
        }
    }

    public void dispose() {
        if (this.m_dbSelector != null) {
            if (this.m_dataSources != null) {
                for (int i = 0; i < this.m_dataSources.length; ++i) {
                    if (this.m_dataSources[i] == null) continue;
                    this.m_dbSelector.release((Object)this.m_dataSources[i]);
                }
                this.m_dataSources = null;
            }
            this.m_dbSelector = null;
        }
    }
}

