/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.http.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.excalibur.instrument.AbstractLogEnabledInstrumentable;
import org.apache.excalibur.instrument.CounterInstrument;
import org.apache.excalibur.instrument.Instrument;
import org.apache.excalibur.instrument.ValueInstrument;
import org.apache.excalibur.instrument.manager.http.server.HTTPURLHandler;

public abstract class AbstractHTTPURLHandler
extends AbstractLogEnabledInstrumentable
implements HTTPURLHandler {
    private String m_path;
    private String m_contentType;
    private String m_encoding;
    private CounterInstrument m_instrumentRequests;
    private ValueInstrument m_instrumentRequestTime;

    public AbstractHTTPURLHandler(String path, String contentType, String encoding) {
        this.m_path = path;
        this.m_contentType = contentType;
        this.m_encoding = encoding;
        this.m_instrumentRequests = new CounterInstrument("requests");
        this.addInstrument((Instrument)this.m_instrumentRequests);
        this.m_instrumentRequestTime = new ValueInstrument("request-time");
        this.addInstrument((Instrument)this.m_instrumentRequestTime);
    }

    public String getPath() {
        return this.m_path;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleRequest(String path, Map parameters, OutputStream os) throws IOException {
        long start = System.currentTimeMillis();
        try {
            this.doGet(path, parameters, os);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.m_instrumentRequests.increment();
            if (this.m_instrumentRequestTime.isActive()) {
                this.m_instrumentRequestTime.setValue((int)(System.currentTimeMillis() - start));
            }
            throw throwable;
        }
        this.m_instrumentRequests.increment();
        if (this.m_instrumentRequestTime.isActive()) {
            this.m_instrumentRequestTime.setValue((int)(System.currentTimeMillis() - start));
        }
    }

    public abstract void doGet(String var1, Map var2, OutputStream var3) throws IOException;

    public String getParameter(Map params, String name, String defaultValue) {
        Object param = params.get(name);
        if (param == null) {
            return defaultValue;
        }
        if (param instanceof String) {
            return (String)param;
        }
        List list = (List)param;
        return (String)list.get(0);
    }

    public String getParameter(Map params, String name) throws FileNotFoundException {
        String param = this.getParameter(params, name, null);
        if (param == null) {
            throw new FileNotFoundException("The " + name + " parameter was not specified.");
        }
        return param;
    }

    public boolean getBooleanParameter(Map params, String name) throws FileNotFoundException {
        return Boolean.getBoolean(this.getParameter(params, name));
    }

    public boolean getBooleanParameter(Map params, String name, boolean defaultValue) {
        String value = this.getParameter(params, name, null);
        if (value == null) {
            return defaultValue;
        }
        if (value.length() < 1) {
            return false;
        }
        char c = value.charAt(0);
        switch (c) {
            case 'T': 
            case 'Y': 
            case 't': 
            case 'y': {
                return true;
            }
        }
        return false;
    }

    public int getIntegerParameter(Map params, String name) throws FileNotFoundException {
        try {
            return Integer.parseInt(this.getParameter(params, name));
        }
        catch (NumberFormatException e) {
            throw new FileNotFoundException("The specified " + name + " was invalid.");
        }
    }

    public int getIntegerParameter(Map params, String name, int defaultValue) {
        String value = this.getParameter(params, name, null);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public long getLongParameter(Map params, String name) throws FileNotFoundException {
        try {
            return Long.parseLong(this.getParameter(params, name));
        }
        catch (NumberFormatException e) {
            throw new FileNotFoundException("The specified " + name + " was invalid.");
        }
    }

    public long getLongParameter(Map params, String name, long defaultValue) {
        String value = this.getParameter(params, name, null);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public String[] getParameters(Map params, String name) {
        Object param = params.get(name);
        if (param == null) {
            return new String[0];
        }
        if (param instanceof String) {
            return new String[]{(String)param};
        }
        List list = (List)param;
        String[] ary = new String[list.size()];
        list.toArray(ary);
        return ary;
    }

    public int[] getIntegerParameters(Map params, String name, int defaultValue) {
        String[] values = this.getParameters(params, name);
        int[] iValues = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            try {
                iValues[i] = Integer.parseInt(values[i]);
                continue;
            }
            catch (NumberFormatException e) {
                iValues[i] = defaultValue;
            }
        }
        return iValues;
    }

    public long[] getLongParameters(Map params, String name, long defaultValue) {
        String[] values = this.getParameters(params, name);
        long[] lValues = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            try {
                lValues[i] = Long.parseLong(values[i]);
                continue;
            }
            catch (NumberFormatException e) {
                lValues[i] = defaultValue;
            }
        }
        return lValues;
    }
}

