/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.LifecycleHelper;

public class SimpleServiceSelector
extends AbstractLogEnabled
implements ServiceSelector,
Configurable,
LogEnabled,
Serviceable,
Disposable,
Contextualizable {
    private final String hintShortHand;
    private final Class componentClass;
    private Map components = new HashMap();
    private ServiceManager serviceManager;
    private Context context;

    public SimpleServiceSelector(String hintShortHand, Class componentClass) {
        this.hintShortHand = hintShortHand;
        this.componentClass = componentClass;
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.serviceManager = serviceManager;
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] componentConfs = configuration.getChildren(this.hintShortHand);
        int i = 0;
        while (i < componentConfs.length) {
            String name = componentConfs[i].getAttribute("name");
            String src = componentConfs[i].getAttribute("src");
            Class<?> clazz = null;
            try {
                clazz = Class.forName(src);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Class not found: " + src + ", declared at " + componentConfs[i].getLocation(), (Throwable)e);
            }
            if (!this.componentClass.isAssignableFrom(clazz)) {
                throw new ConfigurationException("The class \"" + src + "\" is of an incorrect type, it should implement or exted " + this.componentClass.getName());
            }
            Object component = null;
            try {
                component = clazz.newInstance();
                LifecycleHelper lifecycleHelper = new LifecycleHelper(this.getLogger(), this.context, this.serviceManager, null, componentConfs[i]);
                lifecycleHelper.setupComponent(component);
            }
            catch (Exception e) {
                throw new ConfigurationException("Error creating " + this.hintShortHand + " declared at " + componentConfs[i].getLocation(), (Throwable)e);
            }
            this.components.put(name, component);
            ++i;
        }
    }

    public Object select(Object hint) throws ServiceException {
        if (!this.isSelectable(hint)) {
            throw new ServiceException((String)hint, "Non-existing component for this hint");
        }
        String stringHint = (String)hint;
        return this.components.get(stringHint);
    }

    public boolean isSelectable(Object hint) {
        String stringHint = (String)hint;
        return this.components.containsKey(stringHint);
    }

    public void release(Object o) {
    }

    public void dispose() {
        Iterator serviceIt = this.components.values().iterator();
        while (serviceIt.hasNext()) {
            Object service = serviceIt.next();
            if (!(service instanceof Disposable)) continue;
            try {
                ((Disposable)service).dispose();
            }
            catch (Exception e) {
                this.getLogger().error("Error disposing service " + service, (Throwable)e);
            }
        }
    }
}

