/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.HashSet;
import org.apache.cocoon.forms.formmodel.AggregateFieldDefinition;
import org.apache.cocoon.forms.formmodel.FieldDefinition;
import org.apache.cocoon.forms.formmodel.FieldDefinitionBuilder;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.excalibur.xml.sax.XMLizable;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.outerj.expression.Expression;
import org.w3c.dom.Element;

public class AggregateFieldDefinitionBuilder
extends FieldDefinitionBuilder {
    public WidgetDefinition buildWidgetDefinition(Element widgetElement) throws Exception {
        AggregateFieldDefinition aggregateDefinition = new AggregateFieldDefinition();
        this.buildWidgetDefinition(aggregateDefinition, widgetElement);
        Element widgetsElement = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", "widgets", true);
        Element[] fieldElements = DomHelper.getChildElements(widgetsElement, "http://apache.org/cocoon/forms/1.0#definition", "field");
        int i = 0;
        while (i < fieldElements.length) {
            FieldDefinition fieldDefinition = (FieldDefinition)this.buildAnotherWidgetDefinition(fieldElements[i]);
            aggregateDefinition.addWidgetDefinition(fieldDefinition);
            ++i;
        }
        Element splitElement = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", "split", true);
        String patternString = DomHelper.getAttribute(splitElement, "pattern");
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(patternString, 32768);
        }
        catch (MalformedPatternException e) {
            throw new Exception("Invalid regular expression at " + DomHelper.getLocation(splitElement) + ": " + e.getMessage());
        }
        aggregateDefinition.setSplitPattern(pattern, patternString);
        Element[] mapElements = DomHelper.getChildElements(splitElement, "http://apache.org/cocoon/forms/1.0#definition", "map");
        HashSet<String> encounteredFieldMappings = new HashSet<String>();
        int i2 = 0;
        while (i2 < mapElements.length) {
            int group = DomHelper.getAttributeAsInteger(mapElements[i2], "group");
            String field = DomHelper.getAttribute(mapElements[i2], "field");
            if (!aggregateDefinition.hasWidget(field)) {
                throw new Exception("Unkwon widget id \"" + field + "\", at " + DomHelper.getLocation(mapElements[i2]));
            }
            if (encounteredFieldMappings.contains(field)) {
                throw new Exception("Two groups are mapped to the same widget id \"" + field + "\", at " + DomHelper.getLocation(mapElements[i2]));
            }
            encounteredFieldMappings.add(field);
            aggregateDefinition.addSplitMapping(group, field);
            ++i2;
        }
        Element failMessageElement = DomHelper.getChildElement(splitElement, "http://apache.org/cocoon/forms/1.0#definition", "failmessage");
        if (failMessageElement != null) {
            XMLizable failMessage = DomHelper.compileElementContent(failMessageElement);
            aggregateDefinition.setSplitFailMessage(failMessage);
        }
        Element combineElement = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", "combine", true);
        String combineExprString = DomHelper.getAttribute(combineElement, "expression");
        Expression combineExpr = null;
        try {
            combineExpr = this.expressionManager.parse(combineExprString);
        }
        catch (Exception e) {
            throw new Exception("Problem with combine expression defined at " + DomHelper.getLocation(combineElement) + ": " + e.getMessage());
        }
        Class clazz = aggregateDefinition.getDatatype().getTypeClass();
        if (combineExpr.getResultType() != null && !clazz.isAssignableFrom(combineExpr.getResultType())) {
            throw new Exception("The result of the combine expression should be " + clazz.getName() + ", at " + DomHelper.getLocation(combineElement));
        }
        aggregateDefinition.setCombineExpression(combineExpr);
        return aggregateDefinition;
    }
}

