/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingManager;
import org.apache.cocoon.forms.util.DomHelper;
import org.w3c.dom.Element;

public abstract class JXPathBindingBuilderBase
implements LogEnabled {
    private Logger logger;

    public void enableLogging(Logger logger) {
        this.logger = logger;
        if (logger.isDebugEnabled()) {
            logger.debug("JXPathBindingBuilderBase got logger...");
        }
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public abstract JXPathBindingBase buildBinding(Element var1, JXPathBindingManager.Assistant var2) throws BindingException;

    static CommonAttributes getCommonAttributes(Element bindingElm) throws BindingException {
        try {
            if (DomHelper.getAttributeAsBoolean(bindingElm, "readonly", false)) {
                throw new BindingException("Error in binding file " + DomHelper.getLocation(bindingElm) + "\nThe usage of the attribute @readonly has been deprecated in favour of @direction.");
            }
            if (DomHelper.getAttributeAsBoolean(bindingElm, "read-only", false)) {
                throw new BindingException("Error in binding file " + DomHelper.getLocation(bindingElm) + "\nThe usage of the attribute @read-only has been deprecated in favour of @direction.");
            }
            String direction = DomHelper.getAttribute(bindingElm, "direction", "both");
            String leniency = DomHelper.getAttribute(bindingElm, "lenient", null);
            return new CommonAttributes(direction, leniency);
        }
        catch (BindingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BindingException("Error building binding defined at " + DomHelper.getLocation(bindingElm), e);
        }
    }

    static class CommonAttributes {
        final boolean loadEnabled;
        final boolean saveEnabled;
        final Boolean leniency;
        static final CommonAttributes DEFAULT = new CommonAttributes(true, true, null);

        CommonAttributes(String direction, String leniency) {
            this(CommonAttributes.isLoadEnabled(direction), CommonAttributes.isSaveEnabled(direction), CommonAttributes.decideLeniency(leniency));
        }

        CommonAttributes(boolean loadEnabled, boolean saveEnabled, Boolean leniency) {
            this.loadEnabled = loadEnabled;
            this.saveEnabled = saveEnabled;
            this.leniency = leniency;
        }

        private static boolean isLoadEnabled(String direction) {
            return "both".equals(direction) || "load".equals(direction);
        }

        private static boolean isSaveEnabled(String direction) {
            return "both".equals(direction) || "save".equals(direction);
        }

        private static Boolean decideLeniency(String leniency) {
            if (leniency == null) {
                return null;
            }
            return new Boolean(leniency);
        }
    }
}

