/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.forms.binding.Binding;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.util.jxpath.DOMFactory;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.w3c.dom.Node;

public abstract class JXPathBindingBase
implements Binding,
LogEnabled {
    private Logger logger;
    private final JXPathBindingBuilderBase.CommonAttributes commonAtts;
    protected Binding parent;
    protected Map classes;

    private JXPathBindingBase() {
        this(JXPathBindingBuilderBase.CommonAttributes.DEFAULT);
    }

    protected JXPathBindingBase(JXPathBindingBuilderBase.CommonAttributes commonAtts) {
        this.commonAtts = commonAtts;
    }

    public void setParent(Binding binding) {
        this.parent = binding;
    }

    public String getId() {
        return null;
    }

    public Binding getClass(String id) {
        Binding classBinding = null;
        if (this.classes != null) {
            classBinding = (Binding)this.classes.get(id);
        }
        if (classBinding == null) {
            if (this.parent != null) {
                classBinding = this.parent.getClass(id);
                if (this.classes == null) {
                    this.classes = new HashMap();
                }
                this.classes.put(id, classBinding);
            } else {
                throw new RuntimeException("Class \"" + id + "\" not found.");
            }
        }
        return classBinding;
    }

    protected Widget selectWidget(Widget parent, String id) {
        if (id == null) {
            return parent;
        }
        Widget childWidget = null;
        childWidget = parent.lookupWidget(id);
        if (childWidget == null) {
            throw new RuntimeException(this.getClass().getName() + ": Widget \"" + id + "\" does not exist in container \"" + parent.getRequestParameterName() + "\" (" + parent.getLocation() + ").");
        }
        return childWidget;
    }

    public abstract void doLoad(Widget var1, JXPathContext var2) throws BindingException;

    public final void loadFormFromModel(Widget frmModel, JXPathContext jxpc) throws BindingException {
        boolean inheritedLeniency = jxpc.isLenient();
        this.applyLeniency(jxpc);
        if (this.commonAtts.loadEnabled) {
            this.doLoad(frmModel, jxpc);
        }
        jxpc.setLenient(inheritedLeniency);
    }

    public final void loadFormFromModel(Widget frmModel, Object objModel) throws BindingException {
        if (objModel == null) {
            throw new NullPointerException("null object passed to loadFormFromModel() method");
        }
        JXPathContext jxpc = this.makeJXPathContext(objModel);
        this.loadFormFromModel(frmModel, jxpc);
    }

    public abstract void doSave(Widget var1, JXPathContext var2) throws BindingException;

    public final void saveFormToModel(Widget frmModel, JXPathContext jxpc) throws BindingException {
        boolean inheritedLeniency = jxpc.isLenient();
        this.applyLeniency(jxpc);
        if (this.commonAtts.saveEnabled) {
            this.doSave(frmModel, jxpc);
        }
        jxpc.setLenient(inheritedLeniency);
    }

    public void saveFormToModel(Widget frmModel, Object objModel) throws BindingException {
        if (objModel == null) {
            throw new NullPointerException("null object passed to saveFormToModel() method");
        }
        JXPathContext jxpc = this.makeJXPathContext(objModel);
        this.saveFormToModel(frmModel, jxpc);
    }

    private void applyLeniency(JXPathContext jxpc) {
        if (this.commonAtts.leniency != null) {
            jxpc.setLenient(this.commonAtts.leniency.booleanValue());
        }
    }

    private JXPathContext makeJXPathContext(Object objModel) {
        JXPathContext jxpc;
        if (!(objModel instanceof JXPathContext)) {
            jxpc = JXPathContext.newContext((Object)objModel);
            jxpc.setLenient(true);
            if (objModel instanceof Node) {
                jxpc.setFactory((AbstractFactory)new DOMFactory());
            }
        } else {
            jxpc = (JXPathContext)objModel;
        }
        return jxpc;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

