/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.apache.batik.script.rhino.RhinoClassLoader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;

public class BatikSecurityController
extends SecurityController {
    public GeneratedClassLoader createClassLoader(ClassLoader classLoader, Object object) {
        if (object instanceof RhinoClassLoader) {
            return (RhinoClassLoader)object;
        }
        throw new RuntimeException("NOT SUPPORTED");
    }

    public Object getDynamicSecurityDomain(Object object) {
        RhinoClassLoader rhinoClassLoader = (RhinoClassLoader)object;
        if (rhinoClassLoader != null) {
            return rhinoClassLoader;
        }
        return AccessController.getContext();
    }

    public Object execWithDomain(final Context context, final Scriptable scriptable, final Script script, Object object) throws JavaScriptException {
        AccessControlContext accessControlContext;
        if (object instanceof AccessControlContext) {
            accessControlContext = (AccessControlContext)object;
        } else {
            RhinoClassLoader rhinoClassLoader = (RhinoClassLoader)object;
            accessControlContext = rhinoClassLoader.rhinoAccessControlContext;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws JavaScriptException {
                    return script.exec(context, scriptable);
                }
            }, accessControlContext);
        }
        catch (Exception exception) {
            throw new JavaScriptException((Object)exception);
        }
    }
}

