/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.SSORealm;
import org.mortbay.http.SecurityConstraint;
import org.mortbay.http.UserPrincipal;
import org.mortbay.http.UserRealm;
import org.mortbay.jetty.servlet.ServletHttpRequest;
import org.mortbay.util.Code;
import org.mortbay.util.Credential;
import org.mortbay.util.Password;
import org.mortbay.util.URI;

public class FormAuthenticator
implements SecurityConstraint.Authenticator {
    public static final String __J_URI = "org.mortbay.jetty.URI";
    public static final String __J_AUTHENTICATED = "org.mortbay.jetty.Auth";
    public static final String __J_SECURITY_CHECK = "j_security_check";
    public static final String __J_USERNAME = "j_username";
    public static final String __J_PASSWORD = "j_password";
    private String _formErrorPage;
    private String _formErrorPath;
    private String _formLoginPage;
    private String _formLoginPath;
    private transient SSORealm _ssoRealm;

    public String getAuthMethod() {
        return "FORM";
    }

    public void setLoginPage(String path) {
        if (!path.startsWith("/")) {
            Code.warning("form-login-page must start with /");
            path = "/" + path;
        }
        this._formLoginPage = path;
        this._formLoginPath = path;
        if (this._formLoginPath.indexOf(63) > 0) {
            this._formLoginPath = this._formLoginPath.substring(0, this._formLoginPath.indexOf(63));
        }
    }

    public String getLoginPage() {
        return this._formLoginPage;
    }

    public void setErrorPage(String path) {
        if (path == null || path.trim().length() == 0) {
            this._formErrorPath = null;
            this._formErrorPage = null;
        } else {
            if (!path.startsWith("/")) {
                Code.warning("form-error-page must start with /");
                path = "/" + path;
            }
            this._formErrorPage = path;
            this._formErrorPath = path;
            if (this._formErrorPath != null && this._formErrorPath.indexOf(63) > 0) {
                this._formErrorPath = this._formErrorPath.substring(0, this._formErrorPath.indexOf(63));
            }
        }
    }

    public String getErrorPage() {
        return this._formErrorPage;
    }

    public UserPrincipal authenticated(UserRealm realm, String pathInContext, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        ServletHttpRequest request = (ServletHttpRequest)httpRequest.getWrapper();
        HttpServletResponse response = (HttpServletResponse)httpResponse.getWrapper();
        String uri = pathInContext;
        HttpSession session = request.getSession(true);
        if (uri.substring(uri.lastIndexOf("/") + 1).startsWith(__J_SECURITY_CHECK)) {
            FormCredential form_cred = new FormCredential(request.getParameter(__J_USERNAME), request.getParameter(__J_PASSWORD));
            form_cred.authenticate(realm, httpRequest);
            String nuri = (String)session.getAttribute(__J_URI);
            if (nuri == null || nuri.length() == 0) {
                nuri = "/";
            }
            if (form_cred._userPrincipal != null) {
                Code.debug((Object)"Form authentication OK for ", (Object)form_cred._jUserName);
                session.removeAttribute(__J_URI);
                httpRequest.setAuthType("FORM");
                httpRequest.setAuthUser(form_cred._jUserName);
                httpRequest.setUserPrincipal(form_cred._userPrincipal);
                session.setAttribute(__J_AUTHENTICATED, (Object)form_cred);
                if (realm instanceof SSORealm) {
                    ((SSORealm)((Object)realm)).setSingleSignOn(httpRequest, httpResponse, form_cred._userPrincipal, new Password(form_cred._jPassword));
                }
                response.setContentLength(0);
                response.sendRedirect(response.encodeRedirectURL(nuri));
            } else {
                Code.debug((Object)"Form authentication FAILED for ", (Object)form_cred._jUserName);
                if (this._formErrorPage != null) {
                    response.setContentLength(0);
                    response.sendRedirect(response.encodeRedirectURL(URI.addPaths(request.getContextPath(), this._formErrorPage)));
                } else {
                    response.sendError(403);
                }
            }
            return null;
        }
        FormCredential form_cred = (FormCredential)session.getAttribute(__J_AUTHENTICATED);
        if (form_cred != null) {
            if (form_cred._userPrincipal == null) {
                form_cred.authenticate(realm, httpRequest);
                if (realm instanceof SSORealm) {
                    ((SSORealm)((Object)realm)).setSingleSignOn(httpRequest, httpResponse, form_cred._userPrincipal, new Password(form_cred._jPassword));
                }
            } else if (!form_cred._userPrincipal.isAuthenticated()) {
                form_cred._userPrincipal = null;
            }
            if (form_cred._userPrincipal != null) {
                Code.debug((Object)"FORM Authenticated for ", (Object)form_cred._userPrincipal.getName());
                httpRequest.setAuthType("FORM");
                httpRequest.setAuthUser(form_cred._userPrincipal.getName());
                httpRequest.setUserPrincipal(form_cred._userPrincipal);
                return form_cred._userPrincipal;
            }
            session.setAttribute(__J_AUTHENTICATED, null);
        } else if (realm instanceof SSORealm) {
            Credential cred = ((SSORealm)((Object)realm)).getSingleSignOn(httpRequest, httpResponse);
            if (request.getUserPrincipal() != null) {
                form_cred = new FormCredential(request.getUserPrincipal().toString(), cred != null ? cred.toString() : null);
                form_cred._userPrincipal = (UserPrincipal)request.getUserPrincipal();
                form_cred._realm = realm;
                Code.debug((Object)"SSO for ", (Object)form_cred._userPrincipal);
                httpRequest.setAuthType("FORM");
                session.setAttribute(__J_AUTHENTICATED, (Object)form_cred);
                return form_cred._userPrincipal;
            }
        }
        if (pathInContext != null && pathInContext.equals(this._formErrorPath) || pathInContext.equals(this._formLoginPath)) {
            return SecurityConstraint.__NOBODY;
        }
        if (httpRequest.getQuery() != null) {
            uri = uri + "?" + httpRequest.getQuery();
        }
        session.setAttribute(__J_URI, (Object)(request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + URI.addPaths(request.getContextPath(), uri)));
        response.setContentLength(0);
        response.sendRedirect(response.encodeRedirectURL(URI.addPaths(request.getContextPath(), this._formLoginPage)));
        return null;
    }

    private static class FormCredential
    implements Serializable,
    HttpSessionBindingListener {
        String _jUserName;
        String _jPassword;
        transient UserRealm _realm;
        transient UserPrincipal _userPrincipal;

        FormCredential() {
        }

        FormCredential(String username, String password) {
            this._jUserName = username;
            this._jPassword = password;
        }

        public int hashCode() {
            return this._jUserName.hashCode() + this._jPassword.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof FormCredential)) {
                return false;
            }
            FormCredential fc = (FormCredential)o;
            return this._jUserName.equals(fc._jUserName) && this._jPassword.equals(fc._jPassword);
        }

        public UserPrincipal authenticate(UserRealm realm, HttpRequest httpRequest) {
            this._userPrincipal = realm.authenticate(this._jUserName, this._jPassword, httpRequest);
            if (this._userPrincipal != null) {
                this._realm = realm;
            }
            return this._userPrincipal;
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            Code.debug("unbind " + this);
            if (this._realm != null && this._realm instanceof SSORealm) {
                ((SSORealm)((Object)this._realm)).clearSingleSignOn(this._jUserName);
            }
            if (this._userPrincipal != null) {
                this._realm.logout(this._userPrincipal);
            }
            this._userPrincipal = null;
            this._jPassword = null;
        }

        public String toString() {
            return "Cred[" + this._jUserName + "]";
        }
    }
}

