/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;

public class UntypedAtomicValue
extends StringValue {
    public static final UntypedAtomicValue ZERO_LENGTH_UNTYPED = new UntypedAtomicValue("");
    DoubleValue doubleValue = null;

    public UntypedAtomicValue(CharSequence charSequence) {
        this.value = charSequence == null ? "" : charSequence;
        this.typeLabel = BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    public AtomicValue copy(AtomicType atomicType) {
        UntypedAtomicValue untypedAtomicValue = new UntypedAtomicValue(this.value);
        untypedAtomicValue.length = this.length;
        untypedAtomicValue.doubleValue = this.doubleValue;
        untypedAtomicValue.typeLabel = atomicType;
        return untypedAtomicValue;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        int n = builtInAtomicType.getFingerprint();
        if (n == 513) {
            if (this.value.length() == 0) {
                return StringValue.EMPTY_STRING;
            }
            return new StringValue(this.value);
        }
        if (n == 631) {
            return this;
        }
        if (n == 517 || n == 635) {
            try {
                return this.toDouble();
            }
            catch (ValidationException validationException) {
                return new ValidationErrorValue(validationException);
            }
        }
        return super.convertPrimitive(builtInAtomicType, bl, xPathContext);
    }

    public DoubleValue toDouble() throws ValidationException {
        if (this.doubleValue == null) {
            this.doubleValue = new DoubleValue(this.value);
        }
        return this.doubleValue;
    }

    public int compareTo(AtomicValue atomicValue, StringCollator stringCollator, XPathContext xPathContext) {
        if (atomicValue instanceof NumericValue) {
            if (this.doubleValue == null) {
                try {
                    this.doubleValue = (DoubleValue)this.convert(BuiltInAtomicType.DOUBLE, xPathContext);
                }
                catch (XPathException xPathException) {
                    throw new ClassCastException("Cannot convert untyped value \"" + this.getStringValueCS() + "\" to a double");
                }
            }
            return this.doubleValue.compareTo(atomicValue);
        }
        if (atomicValue instanceof StringValue) {
            if (stringCollator instanceof CodepointCollator) {
                return ((CodepointCollator)stringCollator).compareCS(this.getStringValueCS(), ((StringValue)atomicValue).getStringValueCS());
            }
            return stringCollator.compareStrings(this.getStringValue(), ((StringValue)atomicValue).getStringValue());
        }
        TypeHierarchy typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
        AtomicValue atomicValue2 = this.convert((AtomicType)((Value)atomicValue).getItemType(typeHierarchy), xPathContext, true);
        if (atomicValue2 instanceof ValidationErrorValue) {
            throw new ClassCastException("Cannot convert untyped atomic value '" + this.getStringValue() + "' to type " + ((Value)atomicValue).getItemType(typeHierarchy));
        }
        if (!(atomicValue2 instanceof Comparable)) {
            throw new ClassCastException("Type " + ((Value)atomicValue).getItemType(typeHierarchy) + " is not ordered");
        }
        return atomicValue2.compareTo(atomicValue);
    }
}

