/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.PatternMatchExpression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.PrependIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.PatternFinder;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public abstract class Pattern
implements PatternFinder,
Serializable,
Container {
    private String originalText;
    private Executable executable;
    private String systemId;
    private int lineNumber;

    public static Pattern make(String string, StaticContext staticContext, Executable executable) throws XPathException {
        Pattern pattern = new ExpressionParser().parsePattern(string, staticContext);
        pattern.setSystemId(staticContext.getSystemId());
        pattern.setLineNumber(staticContext.getLineNumber());
        pattern.setOriginalText(string);
        pattern.setExecutable(executable);
        pattern = pattern.simplify(staticContext);
        return pattern;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public LocationProvider getLocationProvider() {
        return this.executable.getLocationMap();
    }

    public void setOriginalText(String string) {
        this.originalText = string;
    }

    public Pattern simplify(StaticContext staticContext) throws XPathException {
        return this;
    }

    public Pattern analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        return this;
    }

    public int getDependencies() {
        return 0;
    }

    public Iterator iterateSubExpressions() {
        return Collections.EMPTY_LIST.iterator();
    }

    public void promote(PromotionOffer promotionOffer) throws XPathException {
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public abstract boolean matches(NodeInfo var1, XPathContext var2) throws XPathException;

    protected boolean internalMatches(NodeInfo nodeInfo, XPathContext xPathContext) throws XPathException {
        return this.matches(nodeInfo, xPathContext);
    }

    public SequenceIterator selectNodes(DocumentInfo documentInfo, final XPathContext xPathContext) throws XPathException {
        int n = this.getNodeKind();
        switch (n) {
            case 9: {
                if (this.matches(documentInfo, xPathContext)) {
                    return SingletonIterator.makeIterator(documentInfo);
                }
                return EmptyIterator.getInstance();
            }
            case 2: {
                AxisIterator axisIterator = documentInfo.iterateAxis((byte)4, NodeKindTest.ELEMENT);
                MappingFunction mappingFunction = new MappingFunction(){

                    public SequenceIterator map(Item item) {
                        return ((NodeInfo)item).iterateAxis((byte)2);
                    }
                };
                MappingIterator mappingIterator = new MappingIterator(axisIterator, mappingFunction);
                ItemMappingFunction itemMappingFunction = new ItemMappingFunction(){

                    public Item map(Item item) throws XPathException {
                        if (Pattern.this.matches((NodeInfo)item, xPathContext)) {
                            return item;
                        }
                        return null;
                    }
                };
                return new ItemMappingIterator(mappingIterator, itemMappingFunction);
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                AxisIterator axisIterator = documentInfo.iterateAxis((byte)4, NodeKindTest.makeNodeKindTest(n));
                ItemMappingFunction itemMappingFunction = new ItemMappingFunction(){

                    public Item map(Item item) throws XPathException {
                        if (Pattern.this.matches((NodeInfo)item, xPathContext)) {
                            return item;
                        }
                        return null;
                    }
                };
                return new ItemMappingIterator(axisIterator, itemMappingFunction);
            }
            case 0: {
                AxisIterator axisIterator = documentInfo.iterateAxis((byte)4);
                MappingFunction mappingFunction = new MappingFunction(){

                    public SequenceIterator map(Item item) {
                        return new PrependIterator((NodeInfo)item, ((NodeInfo)item).iterateAxis((byte)2));
                    }
                };
                MappingIterator mappingIterator = new MappingIterator(axisIterator, mappingFunction);
                ItemMappingFunction itemMappingFunction = new ItemMappingFunction(){

                    public Item map(Item item) throws XPathException {
                        if (Pattern.this.matches((NodeInfo)item, xPathContext)) {
                            return item;
                        }
                        return null;
                    }
                };
                return new ItemMappingIterator(mappingIterator, itemMappingFunction);
            }
            case 13: {
                throw new UnsupportedOperationException("Patterns can't match namespace nodes");
            }
        }
        throw new UnsupportedOperationException("Unknown node kind");
    }

    public Expression makeSearchExpression() {
        Expression expression;
        int n = this.getNodeKind();
        switch (n) {
            case 9: {
                expression = new ContextItemExpression();
                break;
            }
            case 2: {
                AxisExpression axisExpression = new AxisExpression(4, NodeKindTest.ELEMENT);
                expression = new PathExpression(axisExpression, new AxisExpression(2, AnyNodeTest.getInstance()));
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                expression = new AxisExpression(4, NodeKindTest.makeNodeKindTest(n));
                break;
            }
            case 0: {
                AxisExpression axisExpression = new AxisExpression(4, NodeKindTest.ELEMENT);
                Block block = new Block();
                Expression[] expressionArray = new Expression[]{new ContextItemExpression(), new AxisExpression(2, AnyNodeTest.getInstance())};
                block.setChildren(expressionArray);
                expression = new PathExpression(axisExpression, block);
                break;
            }
            case 13: {
                throw new UnsupportedOperationException("Patterns can't match namespace nodes");
            }
            default: {
                throw new UnsupportedOperationException("Unknown node kind");
            }
        }
        return new FilterExpression(expression, new PatternMatchExpression(this));
    }

    public int getNodeKind() {
        return 0;
    }

    public int getFingerprint() {
        return -1;
    }

    public abstract NodeTest getNodeTest();

    public double getDefaultPriority() {
        return 0.5;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getPublicId() {
        return null;
    }

    public String toString() {
        if (this.originalText != null) {
            return this.originalText;
        }
        return "pattern matching " + this.getNodeTest().toString();
    }

    public int getHostLanguage() {
        return 50;
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        throw new IllegalArgumentException("Invalid replacement");
    }
}

